<?php

namespace app\logic\admin;

class L_plugin_status_user
{
    /**
     * 记录资源
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'taskType' => 'require',
                'taskId' => 'require',
                'op' => 'require',
                'params' => 'require',
                'randomStr' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->params=is_array($dataObj->request->params)?$dataObj->request->params:toJsonDecode($dataObj->request->params);
            if(empty($dataObj->data->params)){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        if($final_arr["error_no"]==0){
            $days=abs($dataObj->data->params["days"]);
            if($dataObj->data->params["isPermanent"]=="0" && $days == "0"){
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
            if($final_arr["error_no"]==0){
                $dataObj->data->daysSecond=$days;
                if($dataObj->request->op=="1"){
                    $dataObj->data->days=$days;
                }else if($dataObj->request->op=="2"){
                    $dataObj->data->days=$days * -1;
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            }
        }
        if($final_arr["error_no"]==0){
            //写入唯一性检测数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'dataType' => 1,
                'taskType' => $dataObj->request->taskType,
                'taskId' => $dataObj->request->taskId,
                'op' => $dataObj->request->op,
                'randomStr' => $dataObj->request->randomStr,
                'field' => 'id',
            );
            $checkResult=app("S_Admin_op_check")->infoForUnique($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                if($result){
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.doNotRepeatOp"));
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if($final_arr["error_no"]==0){
            //锁定操作
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "dataType"=>"plugin_".trim($dataObj->data->params["domain"])."_".$dataObj->data->params["pluginId"],
            );
            $checkResult=app("S_Admin_categoryOp")->lock($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "domain"=>trim($dataObj->data->params["domain"]),
                "pluginId"=>$dataObj->data->params["pluginId"],
                "guid"=>$dataObj->data->params["guid"],
            );
            $checkResult=app("S_Admin_plugin_status_user")->infoForUnique($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $nowTime=app("ltcmsTime")::getTime();
                if($result){
                    //更新
                    $days=$dataObj->data->days;
                    $isPermanent=$result["isPermanent"]; //永久：0 否，1 是
                    $expireMin=$result["expireMin"];
                    $expireMax=$result["expireMax"];
                    $totalDays=$result["totalDays"] + $days;

                    if($nowTime < $expireMax){
                        $isValid=1;
                    }else{
                        $isValid=0;
                    }

                    if($nowTime >= $expireMin){
                        $isBegin=1;
                    }else{
                        $isBegin=0;
                    }

                    if($dataObj->request->op=="1"){
                        //增加
                        if($isPermanent){
                            if($dataObj->data->params["isPermanent"]){
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.isPermanent"));
                            }else{
                                if($isValid){
                                    $expireMax+=$dataObj->data->daysSecond;
                                }else{
                                    $expireMin=$nowTime;
                                    $expireMax=$expireMin + $dataObj->data->daysSecond;
                                }
                            }
                        }else{
                            if($dataObj->data->params["isPermanent"]){
                                $isPermanent=1;
                            }else{
                                if($isValid){
                                    $expireMax+=$dataObj->data->daysSecond;
                                }else{
                                    $expireMin=$nowTime;
                                    $expireMax=$expireMin + $dataObj->data->daysSecond;
                                }
                            }
                        }
                    }else{
                        //减少
                        if($dataObj->data->params["isPermanent"]){
                            if($isPermanent){
                                $isPermanent=0;
                            }else{
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.isNotPermanent"));
                            }
                        }else{
                            if($isValid){
                                if($isBegin){
                                    //已开始
                                    $diffSecond=$expireMax-$nowTime;
                                    $allowDiff=extendSetting("plugin_time_diff");
                                    if($allowDiff){
                                        $diffSecond+=abs(intval($allowDiff));
                                    }
                                    if($diffSecond >= $dataObj->data->daysSecond){
                                        //天数足够
                                        $expireMax -= $dataObj->data->daysSecond;
                                    }else{
                                        //天数不够
                                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.insufficientDays"));
                                    }
                                }else{
                                    //尚未开始
                                    $diffSecond=$expireMax-$expireMin;
                                    if($diffSecond >= $dataObj->data->daysSecond){
                                        $expireMax -= $dataObj->data->daysSecond;
                                    }else{
                                        //天数不够
                                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.insufficientDays"));
                                    }
                                }
                            }else{
                                //已过期
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.expired"));
                            }
                        }
                    }
                    if($final_arr["error_no"]==0){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$result["id"],
                            'totalDays' => $totalDays,
                            'expireMin' => $expireMin,
                            'expireMax' => $expireMax,
                            'isPermanent' => $isPermanent,
                        );
                        $checkResult=app("S_Admin_plugin_status_user")->update($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                }else{
                    if($dataObj->request->op=="1"){
                        //新增
                        if($dataObj->data->params["isPermanent"]){
                            $totalDays=0;
                            $expireMin=0;
                            $expireMax=0;
                        }else{
                            $totalDays=$dataObj->data->days;
                            $expireMin=$nowTime;
                            $expireMax=$nowTime + $dataObj->data->daysSecond;
                        }
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "domain"=>trim($dataObj->data->params["domain"]),
                            "pluginId"=>$dataObj->data->params["pluginId"],
                            "isPermanent"=>$dataObj->data->params["isPermanent"],
                            "guid"=>$dataObj->data->params["guid"],
                            'totalDays' => $totalDays,
                            'expireMin' => $expireMin,
                            'expireMax' => $expireMax,
                        );
                        $checkResult=app("S_Admin_plugin_status_user")->store($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.insufficientDays"));
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'dataType' => 1,
                'taskType' => $dataObj->request->taskType,
                'taskId' => $dataObj->request->taskId,
                'op' => $dataObj->request->op,
                'randomStr' => $dataObj->request->randomStr,
                'params' => $dataObj->data->params,
            );
            $checkResult=app("S_Admin_op_check")->store($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}