<?php

namespace app\logic\admin;

class L_news
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'title' => 'require',
                'status' => 'require',
                'content' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "title" => $dataObj->request->title,
                'status' => $dataObj->request->status,
            );
            $checkResult = app("S_Admin_news")->store($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if (isset($dataObj->request->content)) {
                    $paramsObj = paramsObj();
                    $paramsObj->params = array(
                        "msgId" => $result["id"],
                        "content" => $dataObj->request->content,
                    );
                    $checkResult = app("S_Admin_newsData")->record($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $final_arr["result"] = $result;
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $final_arr["result"] = $result;
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'title' => 'require',
                'status' => 'require',
                'content' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "title" => $dataObj->request->title,
                'status' => $dataObj->request->status,
            );
            $checkResult = app("S_Admin_news")->update($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if (isset($dataObj->request->content)) {
                    $paramsObj = paramsObj();
                    $paramsObj->params = array(
                        "msgId" => $dataObj->request->id,
                        "content" => $dataObj->request->content,
                    );
                    $checkResult = app("S_Admin_newsData")->record($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $final_arr["result"] = $result;
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $final_arr["result"] = $result;
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
            );
            $checkResult = app("S_Admin_news")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "msgId" => $dataObj->request->id,
                );
                $checkResult = app("S_Admin_newsData")->delete($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $result;
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 获取资源
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
            );
            $checkResult = app("S_Admin_news")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $rowData = $checkResult["result"];
                if ($rowData) {
                    $dataObj->result = $rowData;
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->result) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "msgId" => $dataObj->result["id"],
                );
                $checkResult = app("S_Admin_newsData")->info($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->result["content"] = $checkResult["result"] ? $checkResult["result"]["content"] : "";
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $final_arr["result"] = $dataObj->result;
        }
        return $final_arr;
    }
}