<?php

namespace app\logic\admin;

class L_module
{
    /**
     * 补充路由
     * @param string $paramObj
     */
    public function supplyRoute($paramObj="")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->request->id,
                "field"=>"id,name",
            );
            $checkResult=app("S_Admin_module")->allData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if($result){
                    foreach($result as $val){
                        //检测菜单是否存在
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "pid"=>1,
                            "name"=>$val["name"]."管理",
                            "verify"=>0,
                            "field"=>"id",
                        );
                        $checkResult=app("S_Admin_adminMenu")->infoByUnique($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $menuResult=$checkResult["result"];
                            if(!$menuResult){
                                //模块添加路由
                                addRouteModule($val['id']);
                                //更新设置
                                upSettingCache($val['id']);
                            }
                        }
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj="")
    {
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //录入模块数据
            $paramsObj=paramsObj();
            $paramsObj->mixed=1;
            $paramsObj=blenderObject($paramsObj,$paramObj);
            $checkResult=app("S_Admin_module")->record($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //更新缓存
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>0,
            );
            $checkResult=app("L_Common_caches")->updateModule($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 添加路由
     * @param string $paramObj
     */
    public function routeAdd($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $id=trim($dataObj->request->id);
            $moduleData=module($id);
            $dataObj->data->moduleData=$moduleData;
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->moduleData && $dataObj->data->moduleData["module"]=="article"){
                //查询是否增加过
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'fromId' => $dataObj->data->moduleData["id"],
                    'type' => "module",
                );
                $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if(!$result){
                        if ($final_arr["error_no"] == 0) {
                            //增加菜单
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'pid' => 1,
                                'name' => $dataObj->data->moduleData["name"]."管理",
                                'icon' => 'icon-tuozhan',
                                'sort' => '1',
                                'status' => '1',
                            );
                            $checkResult=app("S_Admin_adminMenu")->store($paramsObj);
                            if ($checkResult["error_no"] == 0) {
                                $dataObj->data->toId=$checkResult["result"]["id"];
                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //增加对应关系
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'fromId' =>$dataObj->data->moduleData["id"],
                                'toId' => $dataObj->data->toId,
                                'type' => "module",
                            );
                            $checkResult=app("S_Admin_map_relation")->store($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //增加权限节点
                            $baseNote=array(
                                "menuId"=>$dataObj->data->toId,
                                "module"=>"admin/Article",
                                "moduleName"=>"{$dataObj->data->moduleData["name"]}管理",
                                "isEnable"=>"1",
                                "other"=>"moduleId=".$dataObj->data->moduleData["id"],
                            );
                            $roleNote=array();
                            $roleNote[]=array(
                                "route"=>"article?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"index",
                                "actionName"=>"{$dataObj->data->moduleData["name"]}列表",
                                "isShow"=>"1",
                                "sort"=>"1",
                            );
                            $roleNote[]=array(
                                "route"=>"article/indexRecycle?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"indexRecycle",
                                "actionName"=>"回收站",
                                "isShow"=>"1",
                                "sort"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/edit",
                                "action"=>"edit",
                                "actionName"=>"编辑",
                                "isShow"=>"2",

                            );
                            $roleNote[]=array(
                                "route"=>"article/create",
                                "action"=>"create",
                                "actionName"=>"创建",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article",
                                "action"=>"delete	",
                                "actionName"=>"删除",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/setRecycle",
                                "action"=>"setRecycle",
                                "actionName"=>"回收站",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"article/setting?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"setting",
                                "actionName"=>"模块设置",
                                "isShow"=>"1",
                                "sort"=>"3",
                            );
                            $roleNote[]=array(
                                "route"=>"fields?moduleId=".$dataObj->data->moduleData["id"],
                                "module"=>"app/admin/controller/Fields",
                                "action"=>"index",
                                "actionName"=>"字段设置",
                                "isShow"=>"1",
                                "sort"=>"4",
                            );
                            $roleNote[]=array(
                                "route"=>"article/recordBatch?moduleId=".$dataObj->data->moduleData["id"],
                                "action"=>"recordBatch	",
                                "actionName"=>"设置更新",
                                "isShow"=>"2",
                            );
                            $roleNote[]=array(
                                "route"=>"category?dataType=module&dataId=".$dataObj->data->moduleData["id"],
                                "action"=>"index",
                                "actionName"=>"分类管理",
                                "module"=>"admin/Category",
                                "isShow"=>"1",
                                "sort"=>"3",
                                "other"=>"dataType=module&dataId=".$dataObj->data->moduleData["id"],
                            );
                            foreach($roleNote  as $nval){
                                if ($final_arr["error_no"] == 0) {
                                    $param=array_merge($baseNote,$nval);
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "menuId"=>$param["menuId"],
                                        "route"=>$param["route"],
                                        "module"=>$param["module"],
                                        "moduleName"=>$param["moduleName"],
                                        "action"=>$param["action"],
                                        "actionName"=>$param["actionName"],
                                        "isShow"=>$param["isShow"],
                                        "isEnable"=>$param["isEnable"],
                                        "other"=>$param["other"],
                                    );
                                    $checkResult=app("S_Admin_adminFunc")->store($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    } else {
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                                if ($final_arr["error_no"]) {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新路由名称
     * @param string $paramObj
     */
    public function routeUpdate($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $id=trim($dataObj->request->id);
            $moduleData=module($id);
            $dataObj->data->moduleData=$moduleData;
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->moduleData && $dataObj->data->moduleData["module"]=="article"){
                //查询是否增加过
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'fromId' => $dataObj->data->moduleData["id"],
                    'type' => "module",
                );
                $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result=$checkResult["result"];
                    if($result){
                        foreach($result as $val){
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'id' => $val["toId"],
                                    'name' => $dataObj->data->moduleData["name"]."管理",
                                );
                                $checkResult=app("S_Admin_adminMenu")->updateForModule($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'menuId' => $val["toId"],
                                    'moduleName' => $dataObj->data->moduleData["name"]."管理",
                                );
                                $checkResult=app("S_Admin_adminFunc")->updateForModule($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"] == 0) {
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    'menuId' => $val["toId"],
                                    'module' => "admin/Article",
                                    'action' => "index",
                                    'actionName' => $dataObj->data->moduleData["name"]."列表",
                                );
                                $checkResult=app("S_Admin_adminFunc")->updateForAction($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 删除路由
     * @param string $paramObj
     */
    public function routeDel($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $dataObj->data->id=trim($dataObj->request->id);
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //查询对应关系
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'fromId' => $dataObj->data->id,
                'type' => "module",
            );
            $checkResult=app("S_Admin_map_relation")->allData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                if($result){
                    foreach($result as $val){
                        if ($final_arr["error_no"] == 0) {
                            //删除节点关系
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'toId' => $val["toId"],
                                'fromId' =>$val["fromId"],
                                'type' => "module",
                            );
                            $checkResult=app("S_Admin_map_relation")->delete($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //删除菜单
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'id' => $val["toId"],
                            );
                            $checkResult=app("S_Admin_adminMenu")->delete($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"] == 0) {
                            //删除节点
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'menuid' => $val["toId"],
                            );
                            $checkResult=app("S_Admin_adminFunc")->deleteByMenuId($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }
}