<?php


namespace app\logic\admin;

use app\utils\encrypt\Hash_pbkdf2;

class L_memberAdmin
{

    /**
     * add
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();
        //校验数据合法
        if ($final_arr["error_no"] == 0) {
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'user' => '',
                'roleId' => 'require|number',
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = parseToArr($paramObj, "params", array());//  参数
            $paramsObj->mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $ret = app("verifyParam")::validatorRequest($paramsObj);
            if ($ret["error_no"] == 0) {
                $dataObj->request = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }

        //判断是否存在
        if ($final_arr["error_no"] == 0) {
            $ret = app("S_Admin_memberAdmin")->getUser($paramObj);

            //逻辑整理,  如果查询到数据 返回数据已存在,如果没查询到数据,判断不是数据不存在报错,就赋值最终数组返回 提示数据不存在,就继续
            if ($ret["error_no"] == "0") {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::DATA_NOT_EXIST, "用户已存在");
            } else if ($ret["error_no"] != app("errorCode")::DATA_NOT_EXIST) {
                $final_arr = $ret;
            }

        }
        //判断角色是否存在
        if ($final_arr["error_no"] == 0) {
            $tempObj = getParamsObj();
            $tempObj->params = ["id" => $dataObj->request->roleId];

            $checkResult = app("S_Admin_adminRole")->info($tempObj);
            if ($checkResult["error_no"] == "0") {
                $dataObj->data->result = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "角色不存在";
            }

        }
        //数据库操作
        if ($final_arr["error_no"] == 0) {
            //调用 数据库层代理执行
            $ret = app("S_Admin_memberAdmin")->store($paramObj);
            if ($ret["error_no"] == "0") {
                $final_arr["result"] = $ret["result"];  //吧响应结果数据赋值到最终数组 结果数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }

        return $final_arr;
    }

    /**
     * set
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {

        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();
        //校验数据合法
        if ($final_arr["error_no"] == 0) {
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'id' => 'require|number',
                'roleId' => 'require|number',
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = parseToArr($paramObj, "params", array());//  参数
            $paramsObj->mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        //判断是否存在
        if ($final_arr["error_no"] == 0) {
            $checkResult = app("S_Admin_memberAdmin")->info($paramObj);
            if ($checkResult["error_no"] == "0") {
                $dataObj->data->result = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        //判断角色是否存在
        if ($final_arr["error_no"] == 0) {
            $tempObj = getParamsObj();
            $tempObj->params = ["id" => $dataObj->request->roleId];

            $checkResult = app("S_Admin_adminRole")->info($tempObj);
            if ($checkResult["error_no"] == "0") {
                if ($checkResult["result"]["status"] != 1) { //检测角色是否启用
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, "角色已禁用");
                } else {
                    $dataObj->result["role"] = $checkResult["result"];
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "角色不存在";
            }

        }
        if ($final_arr["error_no"] == 0) {
            $checkResult = app("S_Admin_memberAdmin")->update($paramObj);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //获取列表
            $checkResult = app("S_Admin_memberAdmin")->listData($dataObj);
            if ($checkResult["error_no"] == "0") {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }


        //获取用到的角色数据
        if ($final_arr["error_no"] == 0 && array_key_exists("data", $final_arr["result"]) && count($final_arr["result"]["data"]) > 0) {
            $tempObj = getParamsObj();

            $ids = array();
            foreach ($final_arr["result"]["data"] as $item) {
                if ($item['roleId']) {
                    $ids[] = $item['roleId'];
                }
            }
            $ids=array_unique($ids);

            $tempObj->params = ["ids" => $ids, "field" => "id,name" ,"verify"=>0];

            //获取列表
            $checkResult = app("S_Admin_adminRole")->idsInfo($tempObj);
            if ($checkResult["error_no"] == "0") {
                //处理结果,变成键值对 id=>名称

                $roleKv = array();
                foreach ($checkResult["result"] as $item) {
                    $roleKv [$item["id"]] = $item["name"];
                }
                $final_arr["result"]["roleInfo"] = $roleKv;
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }


    /**
     * set 设置管理员角色
     * @param string $paramObj
     */
    public function setRole($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();
        //校验数据合法=====================================================
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $params = parseToArr($paramObj, "params", array());//  参数
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'id' => 'require|number',
                'roleId' => 'require|number'
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        //判断管理员id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {
            $paramsObj2 = paramsObj();  //新建一个空对象
            $paramsObj2->params = ["id" => $dataObj->request->id];
            $checkResult = app("S_Admin_memberAdmin")->info($paramsObj2);
            if ($checkResult["error_no"] != "0") {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员id不存在";
            }
        }

        //判断角色id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {
            $paramsObj2 = paramsObj();  //新建一个空对象
            $paramsObj2->params = ["id" => $dataObj->request->roleId];
            $checkResult = app("S_Admin_adminRole")->info($paramsObj2);

            if ($checkResult["error_no"] == "0") {


                if ($checkResult["result"]["status"] != 1) { //检测角色是否启用
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, "角色已禁用");
                } else {
                    $dataObj->result["role"] = $checkResult["result"];
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "角色id不存在";
            }

        }


        if ($final_arr["error_no"] == 0) {
            $ret = app("S_Admin_memberAdmin")->setRole($paramObj);
            if ($ret["error_no"] == "0") {
                $final_arr["result"] = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }


        return $final_arr;
    }

    /**
     * set 设置管理员状态
     * @param string $paramObj
     */
    public function setStatus($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();
        //校验数据合法=====================================================
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $params = parseToArr($paramObj, "params", array());//  参数
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'id' => 'require|number',
                'status' => 'require|between:1,2'
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        //判断管理员id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {
            $paramsObj2 = paramsObj();  //新建一个空对象
            $paramsObj2->params = ["id" => $dataObj->request->id];
            $checkResult = app("S_Admin_memberAdmin")->info($paramsObj2);
            if ($checkResult["error_no"] != "0") {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员id不存在";
            }
        }

        if ($final_arr["error_no"] == 0) {
            $ret = app("S_Admin_memberAdmin")->setRole($paramObj);
            if ($ret["error_no"] == "0") {
                $final_arr["result"] = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }


        return $final_arr;
    }


    /**
     *  原密码改密
     * @param string $paramObj
     */
    public function setNewPassword($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();
        //校验数据合法=====================================================
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $params = parseToArr($paramObj, "params", array());//  参数
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'id' => 'require|number',
                'password' => 'require|password',
                'newPassword' => 'require|password'
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();
            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        //判断管理员id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {
            $paramsObj2 = paramsObj();  //新建一个空对象
            $paramsObj2->params = ["id" => $dataObj->request->id];
            $checkResult = app("S_Admin_memberAdmin")->info($paramsObj2);
            if ($checkResult["error_no"] != "0") {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            } else {
                $dataObj->data->olePassword = $final_arr["result"]["password"];
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "管理员id不存在";
            }
        }


        //判断管理员密码是否错误=====================================================
        if ($final_arr["error_no"] == 0) {
            //其实就是sha256摘要算法, 只是返回的值增加了盐,并编码, 盐不参与计算  验证时,会先解码值然后获取前面摘要结果,在对比,
            if (!Hash_pbkdf2::decrypt($dataObj->data->olePassword, $dataObj->request->password)) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE, app("errorCode")::VERIFY_DATA_FAIL, lang("admin.passwordErr"));
            }

        }


        if ($final_arr["error_no"] == 0) {

            $ret = app("S_Admin_memberAdmin")->setPassWord($paramObj);
            if ($ret["error_no"] == "0") {
                $final_arr["result"] = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }


        return $final_arr;
    }
}