<?php

namespace app\logic\admin;

class L_fields
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $nameRule=config("app.field.name");
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'name' => 'require|regex:'.$nameRule,
                'title' => 'require',
                'type' => 'require',
                'html' => 'require',
                'backend_show' => 'require',
                'use_show' => 'require',
                'default_value' => '',
                'option_value' => '',
                'note' => '',
                'length' => '',
                'width' => '',
                'height' => '',
                'input_limit' => '',
                'addition' => '',
                'sort' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'moduleId' => $dataObj->request->moduleId,
                'name' => $dataObj->request->name,
                'title' => $dataObj->request->title,
                'type' => $dataObj->request->type,
                'html' => $dataObj->request->html,
                'backend_show' => $dataObj->request->backend_show,
                'use_show' => $dataObj->request->use_show,
                'default_value' => $dataObj->request->default_value,
                'option_value' => $dataObj->request->option_value,
                'note' => $dataObj->request->note,
                'length' => $dataObj->request->length,
                'width' => $dataObj->request->width,
                'height' => $dataObj->request->height,
                'input_limit' => $dataObj->request->input_limit,
                'addition' => $dataObj->request->addition,
                'sort' => $dataObj->request->sort,
            );
            $checkResult = app("S_Admin_fields")->store($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $table_name=getTable($dataObj->request->moduleId);
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "tb_name"=>$table_name,
            );
            $checkResult=app("P_table_ddl")->getField($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $tbFieldResult = $checkResult["result"];
                $type=app("P_table_ddl")->getTbFieldType($dataObj->request->type,$dataObj->request->length);
                $collation=app("P_table_ddl")->getTbFieldCollation($dataObj->request->type,"utf8mb4_general_ci");
                $default=app("P_table_ddl")->getTbFieldDefault($dataObj->request->type,$dataObj->request->default_value);
                $field=array(
                    "Field"=>$dataObj->request->name,
                    "Type"=>$type,
                    "Collation"=>$collation,
                    "Null"=>"no",
                    "Default"=>$default,
                );
                if(!isset($tbFieldResult[$dataObj->request->name])){
                    //创建字段
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "tb_name"=>$table_name,
                        "field"=>$field,
                    );
                    $checkResult=app("P_table_ddl")->addTbField($paramsObj);
                    if ($checkResult["error_no"] == 0) {

                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    //字段已存在
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("table_ddl.tableFieldExists",["table"=>$table_name,"field"=>$dataObj->request->name]));
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $nameRule=config("app.field.name");
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'name' => 'require|regex:'.$nameRule,
                'title' => 'require',
                'type' => 'require',
                'html' => 'require',
                'backend_show' => 'require',
                'use_show' => 'require',
                'default_value' => '',
                'option_value' => '',
                'note' => '',
                'length' => '',
                'width' => '',
                'height' => '',
                'input_limit' => '',
                'addition' => '',
                'sort' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //获取数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->request->id,
                "field"=>"table_name,name",
            );
            $checkResult=app("S_Admin_fields")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->fieldResult = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                'name' => $dataObj->request->name,
                'title' => $dataObj->request->title,
                'type' => $dataObj->request->type,
                'html' => $dataObj->request->html,
                'backend_show' => $dataObj->request->backend_show,
                'use_show' => $dataObj->request->use_show,
                'default_value' => $dataObj->request->default_value,
                'option_value' => $dataObj->request->option_value,
                'note' => $dataObj->request->note,
                'length' => $dataObj->request->length,
                'width' => $dataObj->request->width,
                'height' => $dataObj->request->height,
                'input_limit' => $dataObj->request->input_limit,
                'addition' => $dataObj->request->addition,
                'sort' => $dataObj->request->sort,
            );
            $checkResult = app("S_Admin_fields")->update($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "tb_name"=>$dataObj->data->fieldResult["table_name"],
            );
            $checkResult=app("P_table_ddl")->getField($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $tbFieldResult = $checkResult["result"];
                if(isset($tbFieldResult[$dataObj->data->fieldResult["name"]])){
                    $type=app("P_table_ddl")->getTbFieldType($dataObj->request->type,$dataObj->request->length);
                    $collation=app("P_table_ddl")->getTbFieldCollation($dataObj->request->type,"utf8mb4_general_ci");
                    $default=app("P_table_ddl")->getTbFieldDefault($dataObj->request->type,$dataObj->request->default_value);
                    $field=array(
                        "Field"=>$dataObj->request->name,
                        "Type"=>$type,
                        "Collation"=>$collation,
                        "Null"=>"no",
                        "Default"=>$default,
                    );

                    $opField=$tbFieldResult[$dataObj->data->fieldResult["name"]];
                    if(!($opField["meta"]["Field"] == $dataObj->request->name && $opField["meta"]["Length"] == $dataObj->request->length)){
                        //修改字段
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "tb_name"=>$dataObj->data->fieldResult["table_name"],
                            "old_field"=>$dataObj->data->fieldResult["name"],
                            "field"=>$field,
                        );
                        $checkResult=app("P_table_ddl")->changeTbField($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }else{
                    //字段不存在
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("table_ddl.tableFieldNotExists",["table"=>$dataObj->data->fieldResult["table_name"],"field"=>$dataObj->request->name]));
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 删除资源
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'moduleId' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //获取数据
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "field" => "table_name,name",
            );
            $checkResult=app("S_Admin_fields")->getDataById($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                if($result){
                    foreach($result as $val){
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "tb_name"=>$val["table_name"],
                            );
                            $checkResult=app("P_table_ddl")->getField($paramsObj);
                            if ($checkResult["error_no"] == 0) {
                                $tbFieldResult = $checkResult["result"];
                                if(isset($tbFieldResult[$val["name"]])){
                                    //删除字段
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "tb_name"=>$val["table_name"],
                                        "field"=>$val["name"],
                                    );
                                    $checkResult=app("P_table_ddl")->dropTbField($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "moduleId" => $dataObj->request->moduleId,
            );
            $checkResult = app("S_Admin_fields")->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"]=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }
}