<?php

namespace app\logic\admin;

class L_cache
{
    /**
     * 获取位置信息
     * @param string $paramObj
     */
    public function getPositionData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "moduleId"=>$dataObj->request->moduleId,
            );
            $checkResult=app("S_Admin_article")->getPositionData($paramsObj);
            if($checkResult["error_no"]=="0"){
                $result=$checkResult["result"];
                $return=array();
                $return["start_id"]=getVal($result,"startId",0);
                $return["end_id"]=getVal($result,"endId",0);
                $return["loop_nums"]=1000;
                $final_arr["result"]=$return;
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新缓存
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'action' => 'require',
                'all' => '',
            );
            $dataDefault=array();
            $dataDefault["all"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->action=="show"){
                $checkResult=$this->module_show($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->action=="index"){
                $checkResult=$this->module_index($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->action=="all"){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "update"=>"1",
                    "action"=>"show",
                    "all"=>"1",
                );
                $paramsObj=blenderObject($paramsObj,$paramObj);
                $checkResult=$this->module_show($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->action=="list"){
                $checkResult=$this->module_list($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->action=="category_list"){
                $checkResult=$this->module_list($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->action=="category_show"){
                $checkResult=$this->module_show($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                $final_arr=recordLogMsgLevelThree(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 生成首页
     * @param string $paramObj
     */
    public function module_index($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'all' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //tohtml('index', $module);
        }
        if ($final_arr["error_no"] == 0) {
            $module=module($dataObj->request->moduleId);
            $params=array();
            $params["all"]=$dataObj->request->all;
            $params["moduleId"]=$dataObj->request->moduleId;

            $return=array();
            $return["params"]=$params;
            $return["progress_msg"]="{$module['name']} 首页更新成功";
            if($dataObj->request->all=="1"){
                $return["referer"] = LTCMS_ROUTE_PREFIX."/cache/update?action=list";
            }else{
                $return["referer"] = LTCMS_ROUTE_PREFIX."/cache?moduleId=".$dataObj->request->moduleId;
                $return["method"] = "get";
            }
            $final_arr["result"]=$return;
        }
        return $final_arr;
    }

    /**
     * 生成列表页
     * @param string $paramObj
     */
    public function module_list($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'all' => '',
                'categoryId' => '',
            );
            $dataDefault=array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //tohtml('list', $module);
        }
        if ($final_arr["error_no"] == 0) {
            $module=module($dataObj->request->moduleId);
            $params=array();
            $params["all"]=$dataObj->request->all;
            $params["moduleId"]=$dataObj->request->moduleId;

            $return=array();
            $return["params"]=$params;
            $return["progress_msg"]="{$module['name']} 列表页更新成功";
            if($dataObj->request->all=="1"){
                $return["referer"] = LTCMS_ROUTE_PREFIX."/cache/update?action=show";
            }else{
                $return["referer"] = LTCMS_ROUTE_PREFIX."/cache?moduleId=".$dataObj->request->moduleId;
                $return["method"] = "get";
            }
            $final_arr["result"]=$return;
        }
        return $final_arr;
    }

    /**
     * 更新信息
     * @param string $paramObj
     */
    public function module_show($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'action' => 'require',
                'moduleId' => 'require',
                'update' => '',
                'fid' => '',
                'all' => '',
                'tid' => '',
                'sid' => '',
                'page' => '',
                'pageSize' => '',
            );
            $dataDefault=array();
            $dataDefault["update"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if(!isset($dataObj->request->fid) || !isset($dataObj->request->tid) || !isset($dataObj->request->pageSize)){
                //获取最小ID
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "moduleId"=>$dataObj->request->moduleId
                );
                $checkResult=$this->getPositionData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $positionData = $checkResult["result"];
                    if(!isset($dataObj->request->fid)){
                        $dataObj->request->fid=$positionData["start_id"];
                    }
                    if(!isset($dataObj->request->tid)){
                        $dataObj->request->tid=$positionData["end_id"];
                    }
                    if(!isset($dataObj->request->pageSize)){
                        $dataObj->request->pageSize=$positionData["loop_nums"];
                    }
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            if(!is_numeric($dataObj->request->sid)){
                $dataObj->request->sid=$dataObj->request->fid;
            }
        }
        if ($final_arr["error_no"] == 0) {
            $dataObj->data->over=0;
            if($dataObj->request->fid <= $dataObj->request->tid) {
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "moduleId"=>$dataObj->request->moduleId,
                    'page' => $dataObj->request->page,
                    'pageSize' => $dataObj->request->pageSize,
                    'fid' => $dataObj->request->fid,
                );
                $checkResult=app("S_Admin_article")->getProccess($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $result = $checkResult["result"];
                    if($result){
                        if($dataObj->request->update=="1"){
                            $listRule=getModuleItemUrlRule($dataObj->request->moduleId)["rule"];
                            if($listRule){
                                $data=array();
                                foreach($result as $val){
                                    $dataObj->data->itemid=$val["id"];
                                    $replace=array(
                                        "itemid"=>$val["id"],
                                        "year"=>app("ltcmsTime")::getDateTime('Y', $val["addTime"]),
                                        "month"=>app("ltcmsTime")::getDateTime('m', $val["addTime"]),
                                        "day"=>app("ltcmsTime")::getDateTime('d', $val["addTime"]),
                                        "mix_itemid"=>app("ltcmsConfusionCode")->enCode($val["id"]),
                                    );
                                    $categoryData=$val["categoryId"]?category('module',$dataObj->request->moduleId,$val["categoryId"]):array();
                                    if($categoryData){
                                        $replace["catid"]=$categoryData["id"];
                                        $replace["catdir"]=$categoryData["catDir"];
                                    }else{
                                        $replace["catid"]="";
                                        $replace["catdir"]="";
                                    }
                                    $linkurl=urlRuleReplace($replace,$listRule);

                                    $data["id"][]=$val["id"];
                                    $data["data"][$val["id"]]=$linkurl;
                                }
                                $case="";
                                foreach($data["id"] as $id){
                                    if(isset($data["data"][$id])){
                                        $case.="WHEN {$id} THEN '{$data["data"][$id]}' ";
                                    }
                                }
                                $tableName=app("cmsTable")::article($dataObj->request->moduleId);
                                $sql="update `{$tableName}` set linkUrl = CASE id {$case} END where id IN(".implode(",",$data["id"]).")";
                                $ok=Db()->execute($sql);
                                if(!$ok){
                                    $final_arr=recordLogMsgLevelThree(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("cache.updateFail"));
                                }
                            }
                        }else{
                            foreach($result as $val){
                                $dataObj->data->itemid=$val["id"];
//                                tohtml('show', $val); //生成静态文件
                            }
                        }
                        $dataObj->data->itemid += 1;
                        if(count($result) < $dataObj->request->pageSize){
                            $dataObj->data->over=1;
                        }
                    }else{
                        $dataObj->data->itemid=$dataObj->request->fid + $dataObj->request->pageSize;
                        $dataObj->data->over=1;
                    }
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                $dataObj->data->over=1;
                $dataObj->data->itemid=$dataObj->request->fid + $dataObj->request->pageSize;
            }
        }
        if ($final_arr["error_no"] == 0) {
            $module=module($dataObj->request->moduleId);
            $params=array();
            $params["all"]=$dataObj->request->all;
            $params["moduleId"]=$dataObj->request->moduleId;
            if($dataObj->data->over=="0"){
                $params["fid"]=$dataObj->data->itemid;
                $params["tid"]=$dataObj->request->tid;
                $params["sid"]=$dataObj->request->sid;
                $params["pageSize"]=$dataObj->request->pageSize;
                $params["page"]=$dataObj->request->page+1;
            }
            $return=array();
            $return["params"]=$params;
            $return["progress"]=$this->progress($dataObj->request->sid,$dataObj->request->fid,$dataObj->request->tid,$dataObj->data->over);
            if($dataObj->request->update=="1"){
                $msg="更新成功";
            }else{
                $msg="生成成功";
            }
            if($dataObj->request->fid <= $dataObj->request->tid) {
                $return["progress_msg"]="ID 从 {$dataObj->request->fid} 至".($dataObj->data->itemid - 1)." {$module['name']}{$msg}";
            }else{
                $return["progress_msg"]="{$module['name']} {$msg}";
            }
            if($dataObj->data->over=="1"){
                if($dataObj->request->all=="1" && $dataObj->request->update=="1"){
                    $return["referer"] = LTCMS_ROUTE_PREFIX."/cache/update?action=index";
                }else{
                    $return["referer"] = LTCMS_ROUTE_PREFIX."/cache?moduleId=".$dataObj->request->moduleId;
                    $return["method"] = "get";
                }
            }else{
                $return["referer"] = LTCMS_ROUTE_PREFIX."/cache/update?action={$dataObj->request->action}&update={$dataObj->request->update}";
            }
            $final_arr["result"]=$return;
        }
        return $final_arr;
    }

    /**
     * 进度
     * @param $sid
     * @param $fid
     * @param $tid
     * @return int|string
     */
    public function progress($sid, $fid, $tid,$over) {
        if($tid > $sid && $fid < $tid && $over=="0") {
            $p = $this->dround(($fid-$sid)*100/($tid-$sid), 0, true);
            if($p > 100) $p = 100;
            if($p < 1) $p = 1;
            $p = $p.'%';
        } else {
            $p = '100%';
        }
        return $p;
    }

    public function dround($var, $precision = 2, $sprinft = false) {
        $var = round(floatval($var), $precision);
        if($sprinft) $var = sprintf('%.'.$precision.'f', $var);
        return $var;
    }
}