<?php

namespace app\logic\admin;

class L_adminRoleFunc
{
    /**
     * set 设置角色绑定功能id
     * @param string $paramObj
     */
    public function setRoleBindFunc($paramObj = "")
    {
        $dataObj = paramsObj();   //创建空对象
        $dataObj->request = paramsObj();  //赋值请求
        $dataObj->data = paramsObj();    //赋值数据
        $dataObj->data->use_trans = false;        //关闭use_trans
        $dataObj->result = array();           //存放结果
        $dataObj = blenderObject($dataObj, $paramObj); //后面覆盖前面的数据，数组进行融合不完全覆盖。
        $final_arr = logInit();
        //校验数据合法=====================================================
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0); //获取是否混合数据 1混合 0 只用默认
            $params = parseToArr($paramObj, "params", array());//  参数
            $rules = getKeyDefaultRule(array(           //设置规则 如果为空就用默认规则
                'roleId' => 'require|number'
            ));
            $messages = getValidateMessage($rules); //验证规则提示  继承客户端的消息信息
            $dataDefault = array();

            $paramsObj = paramsObj();  //新建一个空对象
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;

            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        //判断角色id是否存在=====================================================
        if ($final_arr["error_no"] == 0) {
            $paramsObj2 = paramsObj();  //新建一个空对象
            $paramsObj2->params = ["id" => $dataObj->request->roleId];
            $checkResult = app("S_Admin_adminRole")->info($paramsObj2);
            if ($checkResult["error_no"] != "0") {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }

            if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                //修改一下返回提示
                $final_arr["error_msg"] = "角色id不存在";
            }
        }
        //过滤 删除已取消授权,增加未授权的===============================================
        if ($final_arr["error_no"] == 0) {
            $ret = app("S_Admin_adminRoleFunc")->setRoleBindFunc($paramObj);
            if ($ret["error_no"] == "0") {
                $final_arr["result"] = $ret["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $ret);
            }
        }


        return $final_arr;
    }

}