<?php

namespace app\logic\admin;

class L_adminMenu
{
    /**
     * 录入菜单
     * @param string $paramObj
     */
    public function recordMenu($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'plugins' => '',
                'data' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //递归循环写入数据
            foreach($dataObj->request->data as $val){
                if ($final_arr["error_no"] == 0) {
                    //写入菜单
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'pid' => $val["pid"],
                        'name' => $val["name"],
                        'icon' => $val["icon"],
                        'sort' => $val["sort"],
                        'status' => $val["status"],
                        'isTop' => getVal($val,"isTop",0),
                    );
                    $checkResult=app("S_Admin_adminMenu")->record($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $menuResult=$checkResult["result"];
                        //写入权限节点数据
                        $nodeData=$val["nodeData"];
                        if($nodeData){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                'menuId' => $menuResult["id"],
                                'plugins' => $dataObj->request->plugins,
                                'data' => $nodeData,
                            );
                            $checkResult=app("S_Admin_adminFunc")->record($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    //写入子菜单
                    $children=$val["children"];
                    if($children){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'plugins' => $dataObj->request->plugins,
                            'data' => $children,
                        );
                        $checkResult=$this->recordMenu($paramsObj);
                        if ($checkResult["error_no"] == 0) {

                        } else {
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
        }
        return $final_arr;
    }

    /*获取 全部广告位kv
     *
     */
    function getAllKeyVal()
    {
        $final_arr = logInit();
        $final_arr["result"] = dict();
        if ($final_arr["error_no"] == 0) {
            $Kv = array();
            $adManageResult = app("S_Admin_adminMenu")->getAll();
            foreach ($adManageResult["result"] as $item) {
                $Kv [$item["id"]] = $item["name"];
            }
            $final_arr["result"] = $Kv;
        }
        return $final_arr;
    }

    //递归菜单 pid
    public function buildTree($data, $parentId = 0)
    {
        $tree = array();
        foreach ($data as $item) {
            if ($item['pid'] == $parentId) {
                $children = $this->buildTree($data, $item['id']);
                if (!empty($children)) {
                    $item['children'] = $children;
                }
                $tree[] = $item;
            }
        }
        return $tree;
    }
}