<?php


namespace app\logic\admin;

class L_adManage
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'positionId' => 'require|number',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->positionId,
            );

            $checkResult = app("S_Admin_adPosition")->info($paramsObj);

            if ($checkResult["error_no"] == 0) {
                //不报错 说明有数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                    //修改一下返回提示
                    $final_arr["error_msg"] = lang("admin.The advertising slot ID does not exist");   //"广告位Id不存在"
                }
            }
        }


        if ($final_arr["error_no"] == 0) {
            $checkResult = app("S_Admin_adManage")->store($paramObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        return $final_arr;
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'positionId' => 'require|number',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->positionId,
            );

            $checkResult = app("S_Admin_adPosition")->info($paramsObj);

            if ($checkResult["error_no"] == 0) {
                //不报错 说明有数据
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                if ($final_arr["error_no"] == app("errorCode")::DATA_NOT_EXIST) {
                    //修改一下返回提示
                    $final_arr["error_msg"] = lang("admin.The advertising slot ID does not exist");   //"广告位Id不存在"
                }
            }
        }

        if ($final_arr["error_no"] == 0) {
            $checkResult = app("S_Admin_adManage")->update($paramObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }
}