<?php

if (! function_exists('getTableData'))
{
    /**
     * 获取表字段信息
     * @param string $paramObj
     */
    function getTableData($tableName,$field,$id,$id_field="id")
    {
        $str="";
        $pre=app("Ltcms_Shop_T_cmsTable")::getPre();
        try {
            $sql="select {$field} from {$pre}{$tableName} where $id_field='{$id}'";
            $result=Db()->execute($sql);
            if($result){
                $fd_count=count(explode(",",$field));
                if($fd_count ==1){
                    $str=getVal($result[0],$field,"");
                }else{
                    $str=$result[0];
                }
            }
        } catch (\Throwable $e) {}
        return $str;
    }
}

if (! function_exists('checkPluginLoad'))
{
    /*
     * 检测插件是否加载
     */
    function checkPluginLoad($pluginName)
    {
        $directory = LTCMS_ROOT . "/plugins/{$pluginName}";
        $info=$directory."/info.json";
        $load=$directory."/load";
        if(is_file($info) || is_file($load)){
            return true;
        }
        return false;
    }
}

if (! function_exists('getSelecdTextEditor'))
{
    /*
     * 获取选择的文本编辑器
     */
    function getSelecdTextEditor()
    {
        $moduleId=request()->param("moduleId","");
        $text_editor=siteSetting("text_editor");
        if($moduleId){
            $module_text_editor=setting("text_editor",$moduleId);
            if($module_text_editor){
                $text_editor=$module_text_editor;
            }
        }
        return $text_editor;
    }
}

if (! function_exists('commendModuleDataShow'))
{
    /*
     * 模块推荐数据展示
     */
    function commendModuleDataShow($moduleId,$data)
    {
        $levelConfig=setting("levelAlias",$moduleId);
        $levelConfig=array_filter(explode("|",$levelConfig));
        $levelName=array();
       if($data){
           foreach($data as $val){
               $levelName[]=getVal($levelConfig,$val-1,"级别{$val}");
           }
       }
       return implode(",",$levelName);
    }
}

if (! function_exists('articleUrlReplace'))
{
    /*
     * 文章链接替换
     */
    function articleUrlReplace($content,$moduleId)
    {
        //获取内链替换数据
        $url_replace_by_word=setting("url_replace_by_word",$moduleId);
        $url_replace_by_word_limit=setting("url_replace_by_word_limit",$moduleId);
        if($url_replace_by_word){
            $words=explode("\n",$url_replace_by_word);
            if($words){
                $search=array();
                $replace=array();
                $placeholder=array();
                foreach($words  as $val){
                    if($val){
                        list($key,$val,$limit)=array_pad(explode("@",trim($val)),3,"");
                        if($key && $val){
                            $impulseSender=impulseSender();
                            $tmp=array();
                            $tmp["key"]=trim($key);
                            $tmp["val"]=trim($val);
                            $tmp["placeholder"]=$impulseSender;
                            $tmp["limit"]=trim($limit)?intval(trim($limit)):($url_replace_by_word_limit?intval(trim($url_replace_by_word_limit)):null);
                            $tmp["val"]='<a href="'.$tmp["val"].'" target="_blank" >'.$tmp["key"].'</a>';
                            $replace[$key]=$tmp;
                            $search[]=$tmp["key"];
                            $placeholder[$impulseSender]=$tmp["val"];
                        }
                    }
                }
                if($search){
                    // 按照搜索数组的长度降序排序
                    usort($search, 'sortByLength');
                    //匹配a链接，先用占位符占位。
                    $a_reg="/<a[^>]*>([^<]*)<\/a>/i";
                    $ok=preg_match_all($a_reg,$content,$matches);
                    $priority=array();
                    if($ok && $matches){
                        foreach($matches[0] as $val){
                            if($val){
                                $impulseSender=impulseSender();
                                $priority[$impulseSender]=$val;
                                $content=str_replace($val,$impulseSender,$content);
                            }
                        }
                        foreach($matches[1] as $val){
                            if(isset($replace[$val]["limit"])){
                                $limit=$replace[$val]["limit"];
                                if(isset($limit)){
                                    $replace[$val]["limit"]=$limit-1;
                                }
                            }
                        }
                    }
                    // 使用 str_replace 进行替换
                    foreach ($search as $value) {
                        $limit=$replace[$value]["limit"];
                        $regVal="/".preg_quote($value,"/")."/";
                        if(isset($limit)){
                            if($limit >0){
                                $content = preg_replace($regVal, $replace[$value]["placeholder"], $content,$limit);
                            }
                        }else{
                            $content = preg_replace($regVal, $replace[$value]["placeholder"], $content);
                        }
                    }
                    //替换需替换数据
                    $content=str_replace(array_keys($placeholder),array_values($placeholder),$content);
                    //反替换回去
                    if($priority){
                        $content=str_replace(array_keys($priority),array_values($priority),$content);
                    }
                }
            }
        }
        return $content;
    }
}

if (! function_exists('articleKeyReplace'))
{
    /*
     * 文章关键词替换
     */
    function articleKeyReplace($content)
    {
        //获取内链替换数据
        $key_replace=siteSetting("key_replace");
        if($key_replace){
            $words=explode("\n",$key_replace);
            if($words){
                $searchMap=array();
                $replaceMap=array();
                foreach($words  as $val){
                    if($val){
                        list($search,$replace)=array_pad(explode("|",trim($val)),2,"");
                        if($search){
                            $replaceMap[]=$replace;
                            $searchMap[]=$search;
                        }
                    }
                }
                $content=str_replace($searchMap,$replaceMap,$content);
            }
        }
        return $content;
    }
}


?>
