<?php
// 获取sign 需要在协议头添加的数据
//传入请求参数数组
function getSignV1($data): array
{
    $secretId = env()->get("APP_secretId", "");
    $secretKey = env()->get("APP_secretKey", "");

    $header = array();
    $signTime = time();
    //添加必要参数 因为协议头会自动被转化所大小写以单独处理
    $header["Lt-Sign-Version"] = 'v1';
    $header["Lt-Secret-Id"] = $secretId;
    $header["Lt-Timestamp"] = $signTime;
    // 对数组的值按key排序
    $data = array_merge($data, $header);

    //多维数组内排序
    $sortFunc = static function (array $params, callable $sortFunc): array {
        array_walk($params, static function (&$item) use ($sortFunc) {
            $item = is_array($item) ? $sortFunc($item, $sortFunc) : $item;
        });
        ksort($params);
        return $params;
    };

    $data = $sortFunc($data, $sortFunc);
    //因为键名有被自动转换成首字母大写,或小写的情况,比如获取所有请求头,就会被自动转首字母大写后面小写,所以只校验值
    $params = implode('', $data);
    $params = $params . $secretKey;
    // 生成sign
    $sign = md5($params);
    $header["Lt-Sign"] = $sign;
    if (env()->get("APP_debug") == 1) {
        $header["Lt-params"] = $params;
    }
    //curt 要求的是文本数组,所以拼一下
    $arr = array();
    foreach ($header as $key => $val) {
        $arr[] = $key . ": " . $val;
    }
    return $arr;
}