<?php


if (!function_exists('getPathAllFiles')) {

    /*获取指定路径全部文件列表
     *
     */
    function getPathAllFiles($directory) {
        $files = [];
        $items = glob($directory . '/*');

        foreach ($items as $item) {
            if (is_file($item)) {
                $files[] = $item;
            } elseif (is_dir($item)) {
                $files = array_merge($files, getPathAllFiles($item));
            }
        }

        return $files;
    }
}
