<?php

if (! function_exists('log_operation'))
{
    /**
     * 记录操作信息
     */
    function log_operation($author,$action,$content="")
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            'author' => $author,
            'action' => $action,
            'content' => $content,
        );
        app("S_Admin_log_operation")->store($paramsObj);
    }
}

if (! function_exists('recordErrorLog'))
{
    /**
     * 记录错误日志
     */
    function recordErrorLog($data)
    {
        $error=array();
        $error["time"]=date("Y-m-d H:i:s");
        $error["code"]=$data["error_no"];
        $error["type"]="businessLogs";
        $error["message"]=$data["error_msg"];
        $error["log_msg"]=$data["log_msg"];
        $error["file"]=$data["call_file"];
        $error["line"]=$data["call_line"];

        $errorFile=LTCMS_ROOT."/runtime/log/".date("Y-m-d").".log.business";
        makeDir(dirname($errorFile));
        file_put_contents($errorFile,toJsonEncode($error).PHP_EOL,FILE_APPEND);
    }
}

if (! function_exists('recordNote'))
{
    /**
     * 记录错误信息
     */
    function recordNote($data)
    {
        $dataJson=is_array($data)?toJsonEncode($data):$data;
        $errorFile=LTCMS_ROOT."/runtime/log/".date("Y-m-d").".log.note";
        makeDir(dirname($errorFile));
        file_put_contents($errorFile,$dataJson.PHP_EOL,FILE_APPEND);
    }
}

/**
 * 日志初始化格式
 * @return array
 */
function logInit()
{
    $result=array(
        "error_level"=>0, //错误级别
        "error_no"=>0, //返回给请求方的错误号
        "error_msg"=>"",//返回给请求方的错误信息
        "log_msg"=>"",//实际错误信息
        "execute_sql"=>"",//执行的SQL
        "call_line"=>"", //调用行数
        "call_file"=>"", //调用文件
        "call_function"=>"", //调用函数
        "call_class"=>"", //调用类
        "debug_backtrace"=>"",//代码执行过程
        "result"=>array(),
        "extra"=>array(),
    );
    return $result;
}


/**
 * 执行过程记录
 * @return string
 */
function debugList($level=10)
{
    $debug=debug_backtrace();
    $useArr=array_slice($debug,0,$level);
    $final=array();
    if($debug)
    {
        foreach($useArr as $key=>$val)
        {
            $final[$key]["file"]=isset($val["file"])?$val["file"]:"";
            $final[$key]["line"]=isset($val["line"])?$val["line"]:"";
            $final[$key]["function"]=isset($val["function"])?$val["function"]:"";
            $final[$key]["class"]=isset($val["class"])?$val["class"]:"";
        }
    }
    return json_encode($final,JSON_UNESCAPED_UNICODE);
}

/**
 * 获取调用处信息
 * @param int $index
 * @return array
 */
function debugInfo($index=1)
{
    $debug=debug_backtrace();
    $callInfo=isset($debug[$index])?$debug[$index]:array();
    unset($debug);
    $data=array();
    $data['call_file']=isset($callInfo['file'])?$callInfo['file']:"";
    $data['call_line']=isset($callInfo['line'])?$callInfo['line']:"";
    $data['call_function']=isset($callInfo['function'])?$callInfo['function']:"";
    $data['call_class']=isset($callInfo['class'])?$callInfo['class']:"";
    return $data;
}

/**
 * 记录错误信息
 * @param array $final_arr
 * @param int $error_no
 * @param string $error_msg
 * @param string $log_msg
 * @return array
 */
function recordLogMsg($debugLevel,$error_level,$error_no,$error_msg,$log_msg="",$extra=array())
{
    $data=logInit();
    $data["error_level"]=$error_level;
    $data["error_no"]=$error_no;
    $data["error_msg"]=$error_msg;
    $data["log_msg"]=$log_msg;
    $data["extra"]=$extra;

    $debugInfo=debugInfo($debugLevel);
    $data=array_merge($data,$debugInfo);
    return $data;
}

/**
 * 记录错误信息 - 过滤一层错误
 * @param array $final_arr
 * @param int $error_no
 * @param string $error_msg
 * @param string $log_msg
 * @return array
 */
function recordLogMsgLevelTwo($error_level,$error_no,$error_msg,$log_msg="",$extra=array())
{
    return recordLogMsg(2,$error_level,$error_no,$error_msg,$log_msg,$extra);
}

/**
 * 记录错误信息 - 过滤一层错误
 * @param array $final_arr
 * @param int $error_no
 * @param string $error_msg
 * @param string $log_msg
 * @return array
 */
function recordLogMsgLevelThree($error_level,$error_no,$error_msg,$log_msg="",$extra=array())
{
    return recordLogMsg(3,$error_level,$error_no,$error_msg,$log_msg,$extra);
}

/**
 * 合并调用函数信息到当前记录
 * @param array $final_arr
 * @param $checkResult
 * @return array
 */
function logCallErrorMsg($final_arr,$checkResult)
{
    $data=array();
    $data['error_level']=$checkResult['error_level'];
    $data['error_no']=$checkResult['error_no'];
    $data['error_msg']=$checkResult['error_msg'];
    $data['log_msg']=$checkResult['log_msg'];
    $data['extra']=$checkResult['extra'];
    $data['call_file']=$checkResult['call_file'];
    $data['call_line']=$checkResult['call_line'];
    $data['call_function']=$checkResult['call_function'];
    $data['call_class']=$checkResult['call_class'];
    $data=array_merge($final_arr,$data);
    return $data;
}
