<?php

if (!function_exists('fields_update')) {
    function fields_update($moduleId,$post_fields) {
        $fd=module_fields($moduleId);
        $fields=array();
        foreach($fd as $fdv){
            if(isset($post_fields[$fdv['name']])){
                $val=$post_fields[$fdv['name']];
                if($fdv['html']=="checkbox"){
                    $val=is_array($val)?implode(",",$val):$val;
                }else if($fdv['html']=="editor"){
                    $val=dhtmlspecialchars($val);
                }
                $fields[$fdv['name']]=$val;
            }
        }
        return $fields;
    }
}

if (!function_exists('module_fields')) {
    function module_fields($moduleId) {
        $fields=array();
        $tableName=getTable($moduleId);
        if($tableName){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "table_name"=>$tableName,
            );
            $checkResult=app("S_Index_fields")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $fields=$checkResult["result"];
            }
        }
        return $fields;
    }
}

if (!function_exists('fields_check')) {
    function fields_check($moduleId,$data) {
        $fd=module_fields($moduleId);
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $rules=array();
            $messages=array();
            foreach($fd as $fdv){
                if($fdv['input_limit']){
                    if($fdv['input_limit']=="1"){
                        $rules[$fdv['name']]="require";
                        $messages[$fdv['name'].".require"]="请输入{$fdv['title']}";
                    }else{
                        $rules[$fdv['name']]="regex:/{$fdv['input_limit']}/i";
                        $messages[$fdv['name'].".regex"]="{$fdv['title']}规则不正确";
                    }
                }
            }
            if($rules && $data){
                $dataDefault = array();
                $paramsObj = paramsObj();
                $paramsObj->params = $data;
                $paramsObj->rules = $rules;
                $paramsObj->messages = $messages;
                $paramsObj->dataDefault = $dataDefault;
                $checkResult = app("verifyParam")::validatorRequest($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->request = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        return $final_arr;
    }
}

if (!function_exists('fields_html')) {
    function fields_html($moduleId,$values = array(),$left = '<td class="tl">', $right = '<td>') {
        $fd=module_fields($moduleId);
        $html = '';
        foreach($fd as $k=>$v) {
            if(!$v['backend_show']) continue;
            $html .= fields_show($k, $values,$left, $right, $v);
        }
        return $html;
    }
}

if (!function_exists('fields_show')) {
    function fields_show($id,$values = array(), $left = '<td class="tl">', $right = '<td>', $fdv = array())
    {
        if(empty($fdv)){
            $fdv=fields($id);
        }
        $html = '';
        $value = $fdv['default_value'];
        if(isset($values[$fdv['name']])) {
            $value = $values[$fdv['name']];
        }
        $addition=$fdv['addition'];

        if($fdv['html'] == 'hidden') {
            $html .= '<input type="hidden" name="post_fields['.$fdv['name'].']" value="'.$value.'" '.$addition.'/>';
        } else {
            $html .= '<tr>'.$left;
            $html .= '<span>';
            if($fdv['input_limit']=="1") {
                $html .= '<strong>*</strong>';
            }
            $html .= $fdv['title'];
            $html .= '</span>';
            $html .= '</td>';
            $html .= $right;

            switch($fdv['html']) {
                case 'text':
                    $html .= '<input type="text" name="post_fields['.$fdv['name'].']" id="'.$fdv['name'].'" value="'.$value.'" '.$addition.'/>';
                    break;
                case 'textarea':
                    $html .= '<textarea name="post_fields['.$fdv['name'].']" id="'.$fdv['name'].'" '.$addition.'>'.$value.'</textarea>';
                    break;
                case 'select':
                    $html .= '<select name="post_fields['.$fdv['name'].']" id="'.$fdv['name'].'" '.$addition.'><option value="">请选择</option>';
                    $rows = array_filter(explode("*", trim($fdv['option_value'])));
                    foreach($rows as $row) {
                        if($row) {
                            $cols = explode("|", trim($row));
                            $html .= '<option value="'.$cols[0].'"'.($cols[0] == $value ? ' selected' : '').'>'.$cols[1].'</option>';
                        }
                    }
                    $html .= '</select>';
                    break;
                case 'radio':
                    if($fdv['option_value']) {
                        $rows = array_filter(explode("*", trim($fdv['option_value'])));
                        foreach($rows as $rw => $row) {
                            if($row) {
                                $cols = explode("|", trim($row));
                                $html .= '<input type="radio" name="post_fields['.$fdv['name'].']" value="'.$cols[0].'" id="'.$fdv['name'].'_'.$rw.'"'.($cols[0] == $value ? ' checked' : '').'> '.$cols[1].'&nbsp;&nbsp;&nbsp;';
                            }
                        }
                    }
                    break;
                case 'checkbox':
                    if($fdv['option_value']) {
                        $value = explode(',', $value);
                        $rows = array_filter(explode("*", trim($fdv['option_value'])));
                        foreach($rows as $rw => $row) {
                            if($row) {
                                $cols = explode("|", trim($row));
                                $html .= '<input type="checkbox" name="post_fields['.$fdv['name'].'][]" value="'.$cols[0].'" id="'.$fdv['name'].'_'.$rw.'"'.(in_array($cols[0], $value) ? ' checked' : '').'> '.$cols[1].'&nbsp;&nbsp;&nbsp;';
                            }
                        }
                    }
                    break;
                case 'date':
                    $html.='<input autocomplete="off" type="text" onfocus="WdatePicker({dateFmt:\'yyyy-MM-dd\'})" name="post_fields['.$fdv['name'].']" value="'.$value.'" class="searchInput lb-input-sm Wdate"  '.$addition.'>';
                    break;
                case 'time':
                    $html.='<input autocomplete="off" type="text" onfocus="WdatePicker({dateFmt:\'HH:mm:ss\'})" name="post_fields['.$fdv['name'].']" value="'.$value.'" class="searchInput lb-input-sm Wdate"  '.$addition.'>';
                    break;
                case 'thumb':
                    $html.='<div class="webUploadBox" style="display:flex;width:100%;"><input  class="long rendercls" name="post_fields['.$fdv['name'].']" type="text" value="'.$value.'" ><div class="webUploadFilePicker upload">[上传]</div></div>';
                    break;
            }
            $html .= $fdv['note'];
            $html .= '</td></tr>';
        }
        return $html;
    }
}
