<?php

if (! function_exists('setting'))
{
    /*
     * 获取配置
     */
    function setting($key,$pid=null)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "itemKey"=>$key,
        );
        if (isset($pid)){
            $paramsObj->params["pid"]=$pid;
        }
        $checkResult=app("L_Common_caches")->getSetting($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('siteSetting'))
{
    /*
     * 获取网站配置
     */
    function siteSetting($key)
    {
        return setting($key,1);
    }
}

if (! function_exists('seoSetting'))
{
    /*
     * 获取网站seo配置
     */
    function seoSetting($key)
    {
        return setting($key,2);
    }
}

if (! function_exists('extendSetting'))
{
    /*
     * 获取扩展配置
     */
    function extendSetting($key)
    {
        return setting($key,4);
    }
}

if (! function_exists('xnSetting'))
{
    /*
     * 获取性能优化配置
     */
    function xnSetting($key)
    {
        return setting($key,3);
    }
}

if (! function_exists('module'))
{
    /*
     * 获取模块数据
     */
    function module($id="",$key="",$print=false)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "id"=>$id,
            "print"=>$print,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getModule($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('moduleByCatDir'))
{
    /*
     * 获取模块数据
     */
    function moduleByCatDir($catDir="",$key="",$print=false)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "catDir"=>$catDir,
            "print"=>$print,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getModuleByCatDir($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('fields'))
{
    /*
     * 获取字段数据
     */
    function fields($id="",$key="")
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "id"=>$id,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getFields($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('category'))
{
    /*
     * 获取模块数据
     */
    function category($dataType="",$dataId="",$key="",$print=false)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "dataType"=>$dataType,
            "dataId"=>$dataId,
            "print"=>$print,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getCategory($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('upPhpConfig'))
{
    /*
     * 更新配置文件
     */
    function upPhpConfig($upConfig)
    {
        if($upConfig && is_array($upConfig)){
            $config=array();
            foreach($upConfig as $key=>$val){
                $config=setData($key,$val,$config);
            }
            $configDirPath=LTCMS_ROOT."/custom/config";
            makeDir($configDirPath);
            foreach($config as $file=>$val){
                $configFile=$configDirPath."/{$file}.php";
                $fileMap=is_file($configFile)?include $configFile:array();
                //合并数据
                $mergeData=mergeArr($fileMap,$val);
                $fileCode="<?php\n\n \$config= ".var_export($mergeData,true).";\nreturn \$config;";
                file_put_contents($configFile,$fileCode);
            }
        }
    }
}

if (! function_exists('upModuleCache'))
{
    /*
     * 更新模块缓存
     */
    function upModuleCache($moduleId)
    {
        if($moduleId){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$moduleId,
            );
            $tmp=app("L_Common_caches")->updateModule($paramsObj);
            if($tmp["error_no"]){
                recordErrorLog($tmp); //记录错误信息
            }
        }
    }
}

if (! function_exists('upFieldCache'))
{
    /*
     * 更新字段缓存
     */
    function upFieldCache($id)
    {
        if($id){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$id,
            );
            $tmp=app("L_Common_caches")->updateFields($paramsObj);
            if($tmp["error_no"]){
                recordErrorLog($tmp); //记录错误信息
            }
        }
    }
}

if (! function_exists('upSettingCache'))
{
    /*
     * 更新设置缓存
     */
    function upSettingCache($moduleId)
    {
        if($moduleId){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "pid"=>$moduleId,
            );
            $tmp=app("L_Common_caches")->updateSetting($paramsObj);
            if($tmp["error_no"]){
                recordErrorLog($tmp); //记录错误信息
            }
        }
    }
}

if (! function_exists('addRouteModule'))
{
    /*
     * 模块增加路由
     */
    function addRouteModule($moduleId)
    {
        if($moduleId){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$moduleId,
            );
            $tmp=app("L_Admin_module")->routeAdd($paramsObj);
            if($tmp["error_no"]){
                recordErrorLog($tmp); //记录错误信息
            }
        }
    }
}

if (! function_exists('updateRouteModule'))
{
    /*
     * 模块更新路由
     */
    function updateRouteModule($moduleId)
    {
        if($moduleId){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$moduleId,
            );
            $tmp=app("L_Admin_module")->routeUpdate($paramsObj);
            if($tmp["error_no"]){
                recordErrorLog($tmp); //记录错误信息
            }
        }
    }
}

if (!function_exists('upCache')) {
    /**
     * 更新缓存
     */
    function upCache($op=null)
    {
        if($op && is_array($op)){
            if(in_array("module",$op)){
                //更新模块缓存
                app("L_Common_caches")->initModule();
            }
            if(in_array("category",$op)){
                //更新分类缓存
                app("L_Common_caches")->initCategory();
            }
            if(in_array("setting",$op)){
                //更新设置缓存
                app("L_Common_caches")->initSetting();
            }
            if(in_array("plugin",$op)){
                //更新插件缓存
                app("L_Common_plugins")->getEnabledPlugins();
            }
            if(in_array("field",$op)){
                //更新字段缓存
                app("L_Common_caches")->initFields();
            }
        }else{
            //更新模块缓存
            app("L_Common_caches")->initModule();
            //更新分类缓存
            app("L_Common_caches")->initCategory();
            //更新设置缓存
            app("L_Common_caches")->initSetting();
            //更新插件缓存
            app("L_Common_plugins")->getEnabledPlugins();
            //更新字段缓存
            app("L_Common_caches")->initFields();
        }
    }
}

if (!function_exists('delCache')) {
    /**
     * 删除缓存
     */
    function delCache($op=null)
    {
        if($op && is_array($op)){
            $dirs=array();
            if(in_array("module",$op)){
                //删除模块缓存
                $dirs[]=runtimePath("cache/module");
            }
            if(in_array("category",$op)){
                //删除分类缓存
                $dirs[]=runtimePath("cache/category");
            }
            if(in_array("setting",$op)){
                //删除设置缓存
                $dirs[]=runtimePath("cache/setting");
            }
            if(in_array("plugin",$op)){
                //删除插件缓存
                $dirs[]=runtimePath("cache/plugin");
            }
            if(in_array("field",$op)){
                //删除字段缓存
                $dirs[]=runtimePath("cache/fields");
            }
        }else{
            $dirs=array();
            //删除模块缓存
            $dirs[]=runtimePath("cache/module");
            //删除分类缓存
            $dirs[]=runtimePath("cache/category");
            //删除设置缓存
            $dirs[]=runtimePath("cache/setting");
            //删除插件缓存
            $dirs[]=runtimePath("cache/plugin");
            //删除字段缓存
            $dirs[]=runtimePath("cache/fields");
        }
        if($dirs){
            foreach($dirs as $dir){
                dirDelete($dir);
            }
        }
    }
}
