<?php

if (! function_exists('apiResult'))
{
    /*
     * api返回信息
     */
    function apiResult($success=false,$codeMsg="",$code=1,$data=null,$extra=null)
    {
        $success=(bool) $success;
        $code=intval($code);
        $codeMsg=(string) $codeMsg;
        if(is_null($extra)){
            $extra=new ArrayObject();
        }
        if(is_null($data)){
            $data=new ArrayObject();
        }
        $map=array(
            "success"=>$success,
            "code"=>$code,
            "codeMsg"=>$codeMsg,
            "data"=>$data,
            "extra"=>$extra,
        );
        return $map;
    }
}

if (! function_exists('apiResponse'))
{
    /*
     * api响应输出
     */
    function apiResponse($success,$codeMsg,$code=1,$data=null,$extra=null)
    {
        header("Content-type:application/json;");
        $apiResult=apiResult($success,$codeMsg,$code,$data,$extra);
        echo json_encode($apiResult,JSON_UNESCAPED_UNICODE);
        exit;
    }
}

if (! function_exists('fileInfo'))
{
    /*
     * 文件信息
     */
    function fileInfo($url,$rqKey,$default=null)
    {
        if(!$url){
            return 0;
        }
        if(strpos($url,"http")===false){
            return is_file($url)?filesize($url):0;
        }else{
            // 初始化cURL会话
            $ch = curl_init($url);

            // 设置cURL选项
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HEADER, true); // 将结果保存到变量而不直接输出
            curl_setopt($ch, CURLOPT_NOBODY, true); // 只获取头部信息，不下载文件内容
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_FAILONERROR, false);
            curl_setopt($ch,CURLOPT_TIMEOUT, 0);// 单位 秒，超时限制。

            // 发送HTTP HEAD请求获取头部信息

            $header = curl_exec($ch);
            // 关闭cURL会话
            curl_close($ch);

            $headArr = explode("\r\n", $header);
            $headers=array();
            if($headArr){
                foreach($headArr as $key=>$val){
                    if($val){
                        list($itemKey,$itemVal)=array_pad(explode(":",$val),2,"");
                        if($itemVal){
                            $headers[strtolower($itemKey)]=$itemVal;
                        }
                    }
                }
            }
            return isset($headers[$rqKey])?trim($headers[$rqKey]):$default;
        }
    }
}

if (! function_exists('spliceFileInfo'))
{
    /*
     * 文件信息
     */
    function spliceFileInfo($url,$fileSize,$nums=0,$sizeDownload=0,$buffer=1024 * 1024)
    {
        $totalNums=ceil($fileSize/$buffer);

        $startTime=app("ltcmsTime")::getTime();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_FAILONERROR, false);
        curl_setopt($ch,CURLOPT_TIMEOUT, 0);// 单位 秒，超时限制。

        if($nums=="0"){
            $start = $nums * $buffer;
            $end = $start + $buffer;
        }else{
            $start = $nums * $buffer + $nums;
            $end = $start + $buffer;
        }
        curl_setopt($ch, CURLOPT_RANGE, $start . '-' . $end);
        header('Content-Range:bytes ' . $start . '-' . $end);
        $content = curl_exec($ch);
        $info = curl_getinfo($ch);
        $endTime=app("ltcmsTime")::getTime();

        $diffTime=$endTime-$startTime;
        if($diffTime <= 0){
            $diffTime=1;
        }
        $rate=$buffer/$diffTime;
        $rateFormat=app("ltcmsFormat")->byte($rate);
        $data=array();
        if($info['http_code']=="206"){
            $jindu=ceil(($nums/$totalNums) * 100);
            $sizeDownload +=$info["size_download"];
            $sizeDownloadFormat=app("ltcmsFormat")->byte($sizeDownload);
            $data["isOver"]=0;
            $data["next"]=$nums+1;
            $data["sizeDownload"]=$sizeDownload;
            $data["start"]=$start;
            $data["jindu"]=$jindu;
            $data["end"]=$end;
            $data["sizeDownloadFormat"]=$sizeDownloadFormat;
            $data["rate"]=$rateFormat;
            $data["content"]=base64_encode($content);
        }else{
            $data["isOver"]=1;
        }
        return $data;
    }
}

if (! function_exists('zip'))
{
    /**
     * 压缩文件
     * @param array $files 待压缩文件 array('d:/test/1.txt'，'d:/test/2.jpg');【文件地址为绝对路径】
     * @param string $filePath 输出文件路径 【绝对文件地址】 如 d:/test/new.zip
     * @return string|bool
     */
    function zip($files, $filePath) {
        //检查参数
        if (empty($files) || empty($filePath)) {
            return false;
        }
        //压缩文件
        $zip = new ZipArchive();
        $zip->open($filePath, ZipArchive::CREATE);
        foreach ($files as $key => $file) {
            //检查文件是否存在
            if (!file_exists($file)) {
                return false;
            }
            $zip->addFile($file, basename($file));
        }
        $zip->close();
        return true;
    }
}

if (! function_exists('unzip'))
{
    /**
     * zip解压方法
     * @param string $filePath 压缩包所在地址 【绝对文件地址】d:/test/123.zip
     * @param string $path 解压路径 【绝对文件目录路径】d:/test
     * @return bool
     */
    function unzip($filePath, $path) {
        if (empty($path) || empty($filePath)) {
            return false;
        }
        $zip = new ZipArchive();
        if ($zip->open($filePath) === true) {
            $zip->extractTo($path);
            $zip->close();
            return true;
        } else {
            return false;
        }
    }
}


?>
