<?php

namespace app\db\api;

class D_news
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']);
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']);
        }
        // 状态
        if (isset($Result['status'])) {
            $statusMap = array();
            $statusMap["1"] = "草稿";
            $statusMap["2"] = "已发布";
            $Result['statusFormat'] = isset($statusMap[$Result['status']]) ? $statusMap[$Result['status']] : "";
        }
        // 返回结果
        return $Result;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'size' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["size"] = "20";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "status", "=",2
            );
            try {
                $result = Db()->name(app("cmsTable")::news())->field($dataObj->request->field)->order("id", "desc")->where($condition)->paginate(array("pageSize"=>$dataObj->request->size));
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        $result["data"][$key] = $this->detailed($val);
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::news())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    $final_arr["result"] =$this->detailed($result);
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新点击量
     * @param string $paramObj
     */
    public function upHits($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $infoData=$checkResult["result"];
                if($infoData){
                    if ($final_arr["error_no"] == 0) {
                        $condition = array();
                        $condition[] = array(
                            "id", "=", $infoData["id"]
                        );
                        $data=array();
                        $data["hits"]="hits+1";
                        if ($data) {
                            $data["updateTime"] = app("ltcmsTime")::getTime();
                            try {
                                $result = Db()->name(app("cmsTable")::news())->where($condition)->prepare(false)->data($data)->update();
                                if($result["affected_rows"] >= "0"){
                                    $return = array();
                                    $return["id"] = $dataObj->request->id;
                                    $return["affected_rows"] = $result["affected_rows"];
                                    $final_arr["result"] =$return;
                                }else{
                                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                                }
                            } catch (\Throwable $e) {
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                            }
                        } else {
                            $return = array();
                            $return["id"] = $dataObj->request->id;
                            $return["affected_rows"] = 0;
                            $final_arr["result"] = $return;
                        }
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}


