<?php

namespace app\db\admin;

class D_setting
{
    /**
     * 获取模块对应设置
     * @param string $paramObj
     */
    public function getSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "pid","=",$dataObj->request->pid
            );
            try{
                $result=Db()->name(app("cmsTable")::setting())->where($condition)->select();
                if($result){
                    $temp=array();
                    foreach($result as $val){
                        $temp[$val["itemKey"]]=$val["itemValue"];
                    }
                    $result=$temp;
                }
                $result=array_merge(config("setting.{$dataObj->request->pid}",array()),$result);
                $moduleType=module($dataObj->request->pid,"module"); //检测是否有对应模块默认设置
                if($moduleType){
                    $result=array_merge(config("setting.{$moduleType}",array()),$result);
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情 by itemKey
     * @param string $paramObj
     */
    public function infoByItemKey($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => 'require',
                "pid"=>"require",
                'field' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "itemKey","=",$dataObj->request->itemKey
            );
            $condition[]=array(
                "pid","=",$dataObj->request->pid
            );
            try{
                $result=Db()->name(app("cmsTable")::setting())->field($dataObj->request->field)->where($condition)->find();
                if($dataObj->request->verify){
                    if(empty($result)){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_NOT_EXIST,lang("sys.dataNotExists"));
                    }
                }
                if($final_arr["error_no"]==0 && $result){
                    $final_arr["result"]=$result;
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => 'require',
                'itemValue' => '',
                'pid' => 'require',
            );
            $dataDefault=array();
            $dataDefault["itemValue"]="";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "itemKey"=>$dataObj->request->itemKey,
                "pid"=>$dataObj->request->pid,
            );
            $checkResult = $this->infoByItemKey($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                if(!$result){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "itemKey"=>$dataObj->request->itemKey,
                        "pid"=>$dataObj->request->pid,
                        "itemValue"=>$dataObj->request->itemValue,
                    );
                    $checkResult = $this->store($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }


    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => 'require',
                'itemValue' => '',
                'pid' => 'require',
            );
            $dataDefault=array();
            $dataDefault["itemValue"]="";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $data=array();
                $data["itemKey"]=$dataObj->request->itemKey;
                $data["itemValue"]=is_array($dataObj->request->itemValue)?implode(",",$dataObj->request->itemValue):$dataObj->request->itemValue;
                $data["pid"]=$dataObj->request->pid;
                $result=Db()->name(app("cmsTable")::setting())->data($data)->insert();
                $return=array();
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据[批量]
     * @param string $paramObj
     */
    public function storeBatch($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'data' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $result = Db()->name(app("cmsTable")::setting())->insertBatch($dataObj->request->data);
                if($result["affected_rows"] >0){
                    $return = array();
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] =$return;
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function deleteByPid($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "pid","=",$dataObj->request->pid
            );
            try{
                $result=Db()->name(app("cmsTable")::setting())->where($condition)->delete();
                $return=array();
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}