<?php

namespace app\db\admin;

use app\model\M_plugin_status_user;

class D_plugin_status_user
{
    /**
     * 信息格式化
     */
    private function detailed($Result, $format="1")
    {
        $nowTime=app("ltcmsTime")::getTime();
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = $Result['updateTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']):"";
        }
        // 开始时间
        if (isset($Result['expireMin'])) {
            $Result['expireMinFormat'] = $Result['expireMin']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['expireMin']):"";
            if($Result['expireMin'] <= $nowTime){
                $Result["isBegin"]=1;
                $Result['isBeginFormat']="已生效";
            }else{
                $Result["isBegin"]=0;
                $Result['isBeginFormat']="未生效";
            }
        }
        // 结束时间
        if (isset($Result['expireMax'])) {
            $Result['expireMaxFormat'] = $Result['expireMax']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['expireMax']):"";
            if($Result['expireMax'] > $nowTime){
                $Result["isValid"]=1;
                $Result['isValidFormat']="有效";
            }else{
                $Result["isValid"]=0;
                $Result['isValidFormat']="无效";
            }
        }
        // 有效时间
        if (isset($Result['expireMin']) && isset($Result['expireMax'])) {
            $effectiveDays = $Result['expireMax'] - $Result['expireMin'];
            $Result['effectiveDays'] = app("ltcmsFormat")->timeSecond($effectiveDays);
        }
        // 累计时间
        if (isset($Result['totalDays'])) {
            $Result['totalDaysFormat'] = app("ltcmsFormat")->timeSecond($Result['totalDays']);
        }
        // 永久
        if (isset($Result['isPermanent'])) {
            $isPermanentMap=array();
            $isPermanentMap["0"]="否";
            $isPermanentMap["1"]="是";
            $Result['isPermanentFormat'] = isset($isPermanentMap[$Result['isPermanent']])?$isPermanentMap[$Result['isPermanent']]:"";
            if($Result['isPermanent']){
                $Result['isValid']=1;
                $Result['isValidFormat']="有效";
            }
        }
        // 返回结果
        return $Result;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault=array();
            $dataDefault["verify"] = 1;
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::pluginStatusUser())->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    if($dataObj->request->format){
                        $result=$this->detailed($result);
                    }
                    $final_arr["result"] = $result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情-唯一
     * @param string $paramObj
     */
    public function infoForUnique($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'domain' => 'require',
                'pluginId' => 'require',
                'guid' => 'require',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "domain", "=", $dataObj->request->domain
            );
            $condition[] = array(
                "pluginId", "=", $dataObj->request->pluginId
            );
            $condition[] = array(
                "guid", "=", $dataObj->request->guid
            );
            try {
                $result = Db()->name(app("cmsTable")::pluginStatusUser())->where($condition)->find();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'guid' => 'require',
                'domain' => 'require',
                'pluginId' => 'require',
                'isPermanent' => 'require',
                'totalDays' => 'require',
                'expireMin' => 'requireIf:isPermanent,1',
                'expireMax' => 'requireIf:isPermanent,1',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'condition' => array(
                    array(
                        "id","=",$dataObj->request->pluginId,
                    ),
                ),
                'field' => 'name',
                'table' => 'plugin',
                'resultField' => 'name',
            );
            $dataObj->data->pluginName=app("C_Common_row_data")->info($paramsObj);
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_plugin_status_user::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["pluginName"]=$dataObj->data->pluginName;
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::pluginStatusUser())->insert($data);
                if($result["affected_rows"] >0){
                    $return = array();
                    $return["id"] = $result["insert_id"];
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number|gt:0',
                'expireMin' => 'require',
                'expireMax' => 'require',
                'totalDays' => 'require',
                'isPermanent' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "field" => "id",
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoResult=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->data->infoResult["id"]
            );
            $fields=M_plugin_status_user::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if ($data) {
                try {
                    if($data["expireMin"] == $data["expireMax"]){
                        $data["expireMin"]=0;
                        $data["expireMax"]=0;
                    }
                    $data["updateTime"] = app("ltcmsTime")::getTime();
                    $result = Db()->name(app("cmsTable")::pluginStatusUser())->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::pluginStatusUser())->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'guid' => '',
                'pluginId' => '',
                'domain' => '',
                'isPermanent' => '',
                'expireMin' => '',
                'expireMax' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"]="*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->expireMin) {
                $condition[] = array(
                    "expireMin", ">=", app("ltcmsTime")::getTime($dataObj->request->expireMin)
                );
            }
            if ($dataObj->request->expireMax) {
                $condition[] = array(
                    "expireMax", "<", app("ltcmsTime")::getTime($dataObj->request->expireMax)
                );
            }
            if ($dataObj->request->pluginId) {
                $condition[] = array(
                    "pluginId", "=", $dataObj->request->pluginId
                );
            }
            if ($dataObj->request->domain) {
                $condition[] = array(
                    "domain", "=", $dataObj->request->domain
                );
            }
            if ($dataObj->request->isPermanent) {
                $condition[] = array(
                    "isPermanent", "=", $dataObj->request->isPermanent
                );
            }
            if ($dataObj->request->guid) {
                $condition[] = array(
                    "guid", "=", $dataObj->request->guid
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::pluginStatusUser())->field($dataObj->request->field)->order("id","desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}