<?php

namespace app\db\admin;

use app\model\M_op_check;

class D_op_check
{
    /**
     * 信息格式化
     */
    private function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 任务类型
        if (isset($Result['taskType']) && isset($Result['dataType'])) {
            $taskTypeMap=array();
            //插件-用户-状态
            $taskTypeMap["1"]=array(
                "1"=>"激活码",
                "2"=>"订单",
                "3"=>"后台",
            );
            //插件记录
            $taskTypeMap["2"]=array(
                "1"=>"发送",
                "2"=>"回滚",
            );
            //插件-状态
            $taskTypeMap["3"]=array(
                "1"=>"激活码",
                "2"=>"订单",
                "3"=>"后台",
            );
            $Result['taskTypeFormat'] = isset($taskTypeMap[$Result['dataType']][$Result['taskType']])?$taskTypeMap[$Result['dataType']][$Result['taskType']]:"";
        }
        // 数据类型
        if (isset($Result['dataType'])) {
            $dataTypeMap=array();
            $dataTypeMap["1"]="插件【状态】【用户】";
            $dataTypeMap["2"]="插件【后台添加】";
            $dataTypeMap["3"]="插件【状态】";
            $Result['dataTypeFormat'] = isset($dataTypeMap[$Result['dataType']])?$dataTypeMap[$Result['dataType']]:"";
        }
        // 操作类型
        if (isset($Result['op'])) {
            $opMap=array();
            $opMap["1"]="增加";
            $opMap["2"]="减少";
            $Result['opFormat'] = isset($opMap[$Result['op']])?$opMap[$Result['op']]:"";
        }
        // 参数
        if (isset($Result['params'])) {
            $Result['paramsFormat'] = $Result['params']?toJsonDecode($Result['params']):array();
        }
        // 返回结果
        return $Result;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault["verify"] = 1;
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::opCheck())->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    if($dataObj->request->format){
                        $result=$this->detailed($result);
                    }
                    $final_arr["result"] = $result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情--唯一性
     * @param string $paramObj
     */
    public function infoForUnique($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'taskType' => 'require',
                'taskId' => 'require',
                'op' => 'require',
                'randomStr' => '',
            );
            $dataDefault=array();
            $dataDefault["randomStr"]="";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition=array();
            $condition[]=array(
                "dataType","=",$dataObj->request->dataType
            );
            $condition[]=array(
                "taskType","=",$dataObj->request->taskType
            );
            $condition[]=array(
                "taskId","=",$dataObj->request->taskId
            );
            $condition[]=array(
                "op","=",$dataObj->request->op
            );
            $condition[]=array(
                "randomStr","=",$dataObj->request->randomStr
            );
            try {
                $result = Db()->name(app("cmsTable")::opCheck())->where($condition)->find();
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'taskType' => 'require',
                'taskId' => 'require',
                'op' => 'require',
                'randomStr' => '',
                'params' => '',
            );
            $dataDefault = array();
            $dataDefault["randomStr"]="";
            $dataDefault["params"]="";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_op_check::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["createTime"] = app("ltcmsTime")::getTime();
                $result = Db()->name(app("cmsTable")::opCheck())->insert($data);
                $return = array();
                $return["id"] = $result["insert_id"];
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => '',
                'taskType' => '',
                'taskId' => '',
                'op' => '',
                'randomStr' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"]="*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->dataType) {
                $condition[] = array(
                    "dataType", "=", $dataObj->request->dataType
                );
            }
            if ($dataObj->request->taskType) {
                $condition[] = array(
                    "taskType", "=", $dataObj->request->taskType
                );
            }
            if ($dataObj->request->taskId) {
                $condition[] = array(
                    "taskId", "=", $dataObj->request->taskId
                );
            }
            if ($dataObj->request->op) {
                $condition[] = array(
                    "op", "=", $dataObj->request->op
                );
            }
            if ($dataObj->request->randomStr) {
                $condition[] = array(
                    "randomStr", "=", $dataObj->request->randomStr
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::opCheck())->field($dataObj->request->field)->order("id","desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}