<?php

namespace app\db\admin;

use app\model\M_goods;

class D_goods
{
    /**
     * 信息格式化
     */
    private function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = $Result['updateTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']):"";
        }
        // 上架时间
        if (isset($Result['upTime'])) {
            $Result['upTimeFormat'] = $Result['upTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['upTime']):"";
        }
        // 下架时间
        if (isset($Result['downTime'])) {
            $Result['downTimeFormat'] = $Result['downTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['downTime']):"";
        }
        // 状态
        if (isset($Result['status'])) {
            $statusMap=array();
            $statusMap["0"]="上架";
            $statusMap["1"]="下架";
            $statusMap["2"]="申请上架";
            $Result['statusFormat'] = isset($statusMap[$Result['status']])?$statusMap[$Result['status']]:"";
        }
        // 规格
        if (isset($Result['specMap'])) {
            $Result['specMapFormat'] = $Result['specMap']?toJsonDecode($Result['specMap']):"";
        }
        // 虚拟配置
        if (isset($Result['virtualConfig'])) {
            $Result['virtualConfigFormat'] = $Result['virtualConfig']?toJsonDecode($Result['virtualConfig']):"";
        }
        // 共享商品
        if (isset($Result['isShare'])) {
            $isShareMap=array();
            $isShareMap["0"]="否";
            $isShareMap["1"]="是";
            $Result['isShareFormat'] = isset($isShareMap[$Result['isShare']])?$isShareMap[$Result['isShare']]:"";
        }
        // 虚拟商品
        if (isset($Result['isVirtual'])) {
            $isVirtualMap=array();
            $isVirtualMap["0"]="否";
            $isVirtualMap["1"]="是";
            $Result['isVirtualFormat'] = isset($isVirtualMap[$Result['isVirtual']])?$isVirtualMap[$Result['isVirtual']]:"";
        }
        // 虚拟商品
        if (isset($Result['isDel'])) {
            $isDelMap=array();
            $isDelMap["0"]="否";
            $isDelMap["1"]="是";
            $Result['isDelFormat'] = isset($isDelMap[$Result['isDel']])?$isDelMap[$Result['isDel']]:"";
        }
        // 插件id
        if (isset($Result['categoryId'])) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'condition' => array(
                    array(
                        "id","=",$Result['categoryId'],
                    ),
                ),
                'field' => 'name',
                'table' => 'category',
                'resultField' => 'name',
            );
            $categoryIdFormat=app("C_Common_row_data")->info($paramsObj);
            $Result['categoryIdFormat'] = $categoryIdFormat;
        }
        // 返回结果
        return $Result;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|integer|gt:0',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault["verify"] = 1;
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::goods())->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    if($dataObj->request->format){
                        $result=$this->detailed($result);
                    }
                    $final_arr["result"] = $result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'name' => 'require',
                'isVirtual' => 'require',
                'goodsNo' => 'require',
                'sellPrice' => 'require',
                'marketPrice' => 'require',
                'costPrice' => '',
                'weight' => 'requireIf:isVirtual,0',
                'storeNums' => 'requireIf:isVirtual,0',
                'status' => 'require',
                'isShare' => 'require',
                'unit' => 'requireIf:isVirtual,0',
                'modelId' => '',
                'thumb' => '',
                'keywords' => '',
                'description' => '',
                'searchWords' => '',
                'sort' => '',
                'specMap' => '',
                'content' => '',
                'sellerId' => '',
                'categoryId' => '',
                'virtualType' => 'requireIf:isVirtual,1',
                'virtualConfig' => 'requireIf:isVirtual,1',
            );
            $dataDefault = array();
            $dataDefault["specMap"]=array();
            $dataDefault["content"]="";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_goods::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::goods())->insert($data);
                if($result["affected_rows"] >0){
                    $return = array();
                    $return["id"] = $result["insert_id"];
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require|number',
                'name' => 'require',
                'isVirtual' => 'require',
                'goodsNo' => 'require',
                'sellPrice' => 'require',
                'marketPrice' => 'require',
                'costPrice' => '',
                'weight' => 'requireIf:isVirtual,0',
                'storeNums' => 'requireIf:isVirtual,0',
                'status' => 'require',
                'isShare' => 'require',
                'unit' => 'requireIf:isVirtual,0',
                'categoryId' => '',
                'modelId' => '',
                'thumb' => '',
                'keywords' => '',
                'description' => '',
                'searchWords' => '',
                'sort' => '',
                'specMap' => '',
                'content' => '',
                'sellerId' => '',
                'verify' => '',
                'virtualType' => 'requireIf:isVirtual,1',
                'virtualConfig' => 'requireIf:isVirtual,1',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->verify) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "id" => $dataObj->request->id,
                    "verify" => 1,
                );
                $checkResult = $this->info($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $fields=M_goods::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if ($data) {
                try {
                    $data["updateTime"] = app("ltcmsTime")::getTime();
                    $result = Db()->name(app("cmsTable")::goods())->where($condition)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            try {
                $result = Db()->name(app("cmsTable")::goods())->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'categoryId' => '',
                'name' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"]="*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            if ($dataObj->request->name) {
                $condition[] = array(
                    "name", "like", "%{$dataObj->request->name}%"
                );
            }
            if ($dataObj->request->categoryId) {
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::goods())->field($dataObj->request->field)->order("id","desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}