<?php

namespace app\db\admin;

class D_commendModuleData
{
    /**
     * 获取数据推荐信息
     * @param string $paramObj
     */
    public function getLevelData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataId' => 'require',
                'moduleId' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $dataIds=is_array($dataObj->request->dataId)?$dataObj->request->dataId:explode(",",$dataObj->request->dataId);
                $condition = array();
                $condition[] = array(
                    "dataId", "in", $dataIds
                );
                $condition[] = array(
                    "moduleId", "=", $dataObj->request->moduleId
                );
                $result=Db()->name(app("cmsTable")::commendModuleData())->field("dataId,commendId")->where($condition)->select();
                if($result){
                    $return=array();
                    foreach($result  as $key=>$val){
                        $return[$val["dataId"]][]=$val["commendId"];
                    }
                    $result=$return;
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据
     * @param string $paramObj
     */
    public function getData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => '',
                'commendId' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $hasData=1;
                $condition = array();
                $condition[] = array(
                    "commendId", "=", $dataObj->request->commendId
                );
                if($dataObj->request->moduleId){
                    $moduleIds=is_array($dataObj->request->moduleId)?$dataObj->request->moduleId:array_filter(explode(",",$dataObj->request->moduleId));
                    if($moduleIds){
                        $condition[] = array(
                            "moduleId", "in", $moduleIds,
                        );
                    }else{
                        $hasData=0;
                    }
                }
                if($hasData){
                    $result=Db()->name(app("cmsTable")::commendModuleData())->field("dataId,moduleId")->where($condition)->order("createTime","desc")->select();
                    $final_arr["result"]=$result;
                }else{
                    $final_arr["result"]=array();
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function infoForUnique($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataId' => 'require',
                'moduleId' => 'require',
                'commendId' => 'require',
                'verify' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            $condition[] = array(
                "moduleId", "=", $dataObj->request->moduleId
            );
            $condition[] = array(
                "commendId", "=", $dataObj->request->commendId
            );
            try {
                $result = Db()->name(app("cmsTable")::commendModuleData())->field("dataId")->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    $final_arr["result"] =$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataId' => 'require',
                'moduleId' => 'require',
                'commendId' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $data = array();
                $data["dataId"] = $dataObj->request->dataId;
                $data["moduleId"] = $dataObj->request->moduleId;
                $data["commendId"] = $dataObj->request->commendId;
                $data["createTime"] = app("ltcmsTime")::getTime();
                $result = Db()->name(app("cmsTable")::commendModuleData())->data($data)->insert();
                if($result["affected_rows"] >0){

                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取推荐数据
     */
    public function getCommendData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => 'require',
                'dataId' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $condition = array();
                $condition[] = array(
                    "dataId", "=", $dataObj->request->dataId
                );
                $condition[] = array(
                    "moduleId", "=", $dataObj->request->moduleId
                );
                $result=Db()->name(app("cmsTable")::commendModuleData())->field("commendId")->where($condition)->select();
                if($result){
                    $result=array_column($result,"commendId");
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataId' => 'require',
                'moduleId' => 'require',
                'commendId' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if ($final_arr["error_no"] == 0) {
            //删除数据
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'dataId' => $dataObj->request->dataId,
                'moduleId' => $dataObj->request->moduleId,
            );
            $checkResult = $this->delete($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->commendId){
                $commendIds=is_array($dataObj->request->commendId)?$dataObj->request->commendId:explode(",",$dataObj->request->commendId);
                if($commendIds){
                    foreach($commendIds as $val){
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj = paramsObj();
                            $paramsObj->params = array(
                                'dataId' => $dataObj->request->dataId,
                                'moduleId' => $dataObj->request->moduleId,
                                'commendId' => $val,
                            );
                            $checkResult = $this->infoForUnique($paramsObj);
                            if ($checkResult["error_no"] == 0) {
                                $result = $checkResult["result"];
                                if(!$result){
                                    $paramsObj = paramsObj();
                                    $paramsObj->params = array(
                                        'dataId' => $dataObj->request->dataId,
                                        'moduleId' => $dataObj->request->moduleId,
                                        'commendId' => $val,
                                    );
                                    $checkResult = $this->store($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    } else {
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                }
                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataId' => 'require',
                'moduleId' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            $condition[] = array(
                "moduleId", "=", $dataObj->request->moduleId
            );
            try {
                $result = Db()->name(app("cmsTable")::commendModuleData())->where($condition)->delete();
                $return = array();
                $return["affected_rows"] = $result["affected_rows"];
                $final_arr["result"] = $return;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}