<?php

namespace app\db\admin;

class D_articleData
{
    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => 'require',
                'id' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "id","=",$dataObj->request->id
            );
            try{
                $result=Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->field($dataObj->request->field)->where($condition)->find();
                if($dataObj->request->verify){
                    if(empty($result)){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_NOT_EXIST,lang("sys.dataNotExists"));
                    }
                }
                if($final_arr["error_no"]==0 && $result){
                    $final_arr["result"]=$result;
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => 'require|integer',
                'articleContent' => '',
                'articleId' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $paramsObj->noFilter=array("articleContent");
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "moduleId"=>$dataObj->request->moduleId,
                "id"=>$dataObj->request->articleId,
            );
            $checkResult = $this->info($paramsObj);
            if($checkResult["error_no"]==0){
                $data=$checkResult["result"];
                if($data){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "moduleId"=>$dataObj->request->moduleId,
                        "articleId"=>$dataObj->request->articleId,
                        "articleContent"=>$dataObj->request->articleContent,
                        "verify"=>0,
                    );
                    $checkResult = $this->update($paramsObj);
                    if($checkResult["error_no"]==0){
                        $final_arr["result"]=$checkResult["result"];
                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }else{
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "moduleId"=>$dataObj->request->moduleId,
                        "articleId"=>$dataObj->request->articleId,
                        "articleContent"=>$dataObj->request->articleContent,
                    );
                    $checkResult = $this->store($paramsObj);
                    if($checkResult["error_no"]==0){
                        $final_arr["result"]=$checkResult["result"];
                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => 'require|integer',
                'articleContent' => '',
                'articleId' => 'require',
            );
            $dataDefault=array();
            $dataDefault["articleContent"]="";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $paramsObj->noFilter=array("articleContent");
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $data=array();
                $data["articleContent"]=$dataObj->request->articleContent;
                $data["id"]=$dataObj->request->articleId;
                $result=Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->data($data)->insert();
                $return=array();
                $return["id"]=$result["insert_id"];
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'moduleId' => 'require|integer',
                'articleContent' => '',
                'articleId' => 'require',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["verify"]=1;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $paramsObj->noFilter=array("articleContent");
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->verify){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "moduleId"=>$dataObj->request->moduleId,
                    "id"=>$dataObj->request->articleId,
                    "verify"=>1,
                );
                $checkResult = $this->info($paramsObj);
                if($checkResult["error_no"]==0){

                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "id","=",$dataObj->request->articleId
            );
            $data=array();
            if(isset($dataObj->request->articleContent)){
                $data["articleContent"]=$dataObj->request->articleContent;
            }
            if($data){
                try{
                    $result=Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->where($condition)->data($data)->update();
                    $return=array();
                    $return["id"]=$dataObj->request->articleId;
                    $return["affected_rows"]=$result["affected_rows"];
                    $final_arr["result"]=$return;
                }catch (\Throwable $e){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
                }
            }else{
                $return=array();
                $return["id"]=$dataObj->request->articleId;
                $return["affected_rows"]=0;
                $final_arr["result"]=$return;
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'moduleId' => 'require|integer|gt:0',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $ids=is_array($dataObj->request->id)?$dataObj->request->id:explode(",",$dataObj->request->id);
            $condition=array();
            $condition[]=array(
                "id","in",$ids
            );
            try{
                $result=Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->where($condition)->delete();
                $return=array();
                $return["affected_rows"]=$result["affected_rows"];
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}