<?php

$url_htm=lang("sys.url_htm");
$url_php=lang("sys.url_php");
$url_rewrite=lang("sys.url_rewrite");
$category=lang("sys.category");

$config=array();
$config['listUrlRule'] = array(
    "htm"=>array(
        "list"=>array(
            "0"=>array(
                "example"=>"({$url_htm})catdir/25.html",
                "index"=>'{$catdir}/{$catid}.{$file_ext}',
                "page"=>'{$catdir}/{$catid}_{$page}.{$file_ext}',
            ),
        ),
        "item"=>array(
            "0"=>array(
                "example"=>"({$url_htm})200810/125.html",
                "index"=>'{$year}{$month}/{$itemid}.{$file_ext}',
            ),
        ),
    ),
    "php"=>array(
        "list"=>array(
            "0"=>array(
                "example"=>"({$url_php})list?catId=1&page=2",
                "index"=>'list?catId={$catid}',
                "page"=>'list?catId={$catid}&page={$page}',
            ),
            "1"=>array(
                "example"=>"({$url_rewrite})list-htm-catid-1-page-2.html",
                "index"=>'list-htm-catid-{$catid}.html',
                "page"=>'list-htm-catid-{$catid}-page-{$page}.html',
            ),
            "2"=>array(
                "example"=>"({$url_rewrite})list-1-2.html",
                "index"=>'list-{$catid}.html',
                "page"=>'list-{$catid}-{$page}.html',
            ),
            "3"=>array(
                "example"=>"({$url_rewrite})list/1/",
                "index"=>'list/{$catid}/',
                "page"=>'list-{$catid}-{$page}.html',
            ),
            "4"=>array(
                "example"=>"({$url_rewrite})mulu-c1-2.html",
                "index"=>'{$catdir}-c{$catid}-1.html',
                "page"=>'{$catdir}-c{$catid}-{$page}.html',
            ),
            "5"=>array(
                "example"=>"({$url_rewrite})/ID/",
                "index"=>'{$catid}/',
                "page"=>'{$catid}p{$page}',
            ),
        ),
        "item"=>array(
            "0"=>array(
                "example"=>"({$url_rewrite})show-1.html",
                "index"=>'show-{$itemid}.html',
            ),
            "1"=>array(
                "example"=>"({$url_rewrite})show/1/",
                "index"=>'show/{$itemid}',
            ),
            "2"=>array(
                "example"=>"({$url_rewrite})show-htm-itmeid-1.html",
                "index"=>'show-htm-itemid-{$itemid}.html',
            ),
            "3"=>array(
                "example"=>"({$url_rewrite})ID.html",
                "index"=>'{$itemid}.html',
            ),
            "4"=>array(
                "example"=>"({$url_php})show?articleId=1",
                "index"=>'show?articleId={$itemid}',
            ),
            "5"=>array(
                "example"=>"({$url_rewrite})adf8iyki.html",
                "index"=>'{$mix_itemid}.html',
            ),
            "6"=>array(
                "example"=>"({$url_rewrite})2024-05-06/1.html",
                "index"=>'{$year}-{$month}-{$day}/{$itemid}.html',
            ),
        ),
    ),
);

return $config;
