<?php

namespace app\client\index;

class C_article
{
    /**
     * 获取文章详细信息
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Index_article")->info($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
    /**
     * 获取相关文章
     * @param string $paramObj
     */
    public function getCorrelationList($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("L_Index_article")->getCorrelationList($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
    /**
     * 获取中间下边文章列表
     * @param string $paramObj
     */
    public function getList($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj->params=array(
            "field"=>"id,moduleId,title,thumb,description,attribute,addTime,updateTime,author,hits",
        );
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Index_article")->getList($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
    /**
     * 获取热门文章列表 /就是特定时间内浏览量最多的
     * @param string $paramObj
     */
    public function getHighClickList($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Index_article")->getHighClickList($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
    /**
     * 上传点击日志+1
     * @param string $paramObj
     */
    public function uploadClickLogs($paramObj = "")
    {
        $paramsObj = paramsObj();
        $paramsObj->mixed = 1;
        $paramsObj = blenderObject($paramsObj, $paramObj);
        $checkResult = app("S_Index_article")->uploadClickLogs($paramsObj);
        if ($checkResult["error_no"] == 0) {
            return apiResult(true, "success", 0, $checkResult["result"], $checkResult["extra"]);
        } else {
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false, $checkResult["error_msg"], $checkResult["error_no"]);
        }
    }
}