<?php

namespace app\client\admin;

class C_fields
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $messages=array();
        $messages["title.require"]="请输入字段名称";
        $messages["name.require"]="请输入字段";
        $messages["name.regex"]="字段规则不正确(小写字母(a-z),数字(0-9) 推荐使用字母,不能以数字开头)";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_fields")->store($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result['id']){
                //更新字段缓存
                upFieldCache($result['id']);
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $messages=array();
        $messages["title.require"]="请输入字段名称";
        $messages["name.require"]="请输入字段";
        $messages["name.regex"]="字段规则不正确(小写字母(a-z),数字(0-9) 推荐使用字母,不能以数字开头)";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_fields")->update($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result['id']){
                //更新字段缓存
                upFieldCache($result['id']);
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_fields")->listData($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 详情
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_fields")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_fields")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result['id']){
                foreach($result['id'] as $id){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$id,
                    );
                    $tmp=app("L_Common_caches")->updateFields($paramsObj);
                    if($tmp["error_no"]){
                        recordErrorLog($tmp); //记录错误信息
                    }
                }
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}