<?php

namespace app\client\admin;

class C_article
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $messages=array();
        $messages["categoryId.require"]="请选择分类";
        $messages["title.require"]="请输入文章标题";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->store($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result["id"]){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "moduleId"=>$result["moduleId"],
                    "id"=>$result["id"],
                );
                app("S_Admin_article")->updateLinkurl($paramsObj);
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 更新资源
     * @param string $paramObj
     */
    public function update($paramObj=""){
        $messages=array();
        $messages["categoryId.require"]="请选择分类";
        $messages["title.require"]="请输入文章标题";
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->messages=$messages;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->update($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            if($result["id"]){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "moduleId"=>$result["moduleId"],
                    "id"=>$result["id"],
                );
                app("S_Admin_article")->updateLinkurl($paramsObj);
            }
            return apiResult(true,"success",0,$result,$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 文章列表数据
     * @param string $paramObj
     */
    public function listData($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("S_Admin_article")->listData($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }


    /**
     * 文章详情
     * @param string $paramObj
     */
    public function info($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->info($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除反斜线
     * @param string $paramObj
     */
    public function removeBackslashes($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->removeBackslashes($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->delete($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }


    /**
     * 批量修改文章状态
     * @param string $paramObj
     */
    public function setStatus($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->setStatus($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
    /**
     * 批量修改文章回收站
     * @param string $paramObj
     */
    public function setRecycle($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->setRecycle($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
    /**
     * 批量修改文章设置
     * @param string $paramObj
     */
    public function settingRecordBatch($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Admin_article")->settingRecordBatch($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}