<?php

namespace app\admin\controller;

use app\client\admin\C_systemUpdate;
use app\logic\admin\L_systemUpdate;

//控制层 渲染最后视图信息,模拟请求数据
class SystemUpdate
{
    public $client = null;

    /**
     * @menuName 无菜单
     * 上面的是菜单的名字
     * @moduleName 系统更新
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_systemUpdate();
    }



    /**
     * @actionName 更新系统版本页
     * @show 1
     * 展示设置
     */
    public function updateVersion()
    {
        $updateList=array();
        $ret=(new L_systemUpdate)->getNewVersion();
        if ($ret["error_no"]==0){
            $updateList=$ret["result"];
        }
        $data = array();
        $data["request"] = request()->param();
        $data["updateList"] =json_encode($updateList);
        return view("admin/default/update", $data);
    }

    /**
     * @actionName 备份文件页
     * @show 1
     * 展示设置
     */
    public function backups()
    {
        $result = $this->client->updateVersion();
        $md5List = array();
        $newVersion=array();
        if (isset($result["data"]) && isset($result["data"]["list"])) {
            $md5List = $result["data"]["list"];
            $newVersion = $result["data"]["info"];
        }
        $data = array();
        $data["request"] = request()->param();
        $data["newVersion"] = $newVersion;
        $data["md5List"] = $md5List;
        $data["update"] = ["newVersion" => $newVersion, "version" => LT_VERSION];
        return view("admin/default/backups", $data);
    }

    /**
     * @actionName 更新系统版本
     * @show 2
     * 展示设置
     */
    public function updateNewVersion()
    {
        $result = $this->client->updateNewVersion();
        return jsonResponse($result);
    }

    /**
     * @actionName 一键备份
     * @show 2
     * 展示设置
     */
    public function UpdateBackup()
    {
        $result = $this->client->UpdateBackup();
        return jsonResponse($result);
    }


}