<?php

namespace app\admin\controller;

use app\client\admin\C_singlePageGroup;


//单页管理
class SinglePageGroup
{

    public $client;

    /**
     * @menuName 拓展管理
     * 上面的是菜单的名字
     * @moduleName 单页分组管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_singlePageGroup();
    }

    
    /**
     * @actionName 读取详情
     * @show 2
     * 展示设置
     */
    public function info()
    {
        $result = $this->client->info();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/singlePageGroup/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        $info=array();
        if ($result["success"]) {
            $info = $result["data"];
        }





        $data = array();
        $data["info"] = $info;
        $data["request"] = request()->param();

        return view("admin/singlePageGroup/edit", $data);
    }

    /**
     * @actionName  更新
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  单页分类列表
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();

        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/singlePageGroup/index", $data);
    }
}