<?php

namespace app\admin\controller;

use app\client\admin\C_singlePage;
use app\client\admin\C_friendLink;
use app\logic\admin\L_friendLink;
use ltcms\lib\Request;

//单页管理
class SinglePage
{

    public $client;

    /**
     * @menuName 拓展管理
     * 上面的是菜单的名字
     * @moduleName 单页管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_singlePage();
    }

    
    /**
     * @actionName 读取详情
     * @show 2
     * 展示设置
     */
    public function info()
    {
        $result = $this->client->info();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->client->store();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $group=app("L_Admin_singlePageGroup")->getAllKeyVal(getParamsObj());
        $template=config("template");
        $data = array();
        $data["settingData"] = $template;
        $data["group"] = $group;
        $data["request"] = request()->param();
        return view("admin/singlePage/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        if ($result["success"]) {
            $result = $result["data"];
        }
        $group=app("L_Admin_singlePageGroup")->getAllKeyVal(getParamsObj());
        $template=config("template");
        $data = array();
        $data["settingData"] = $template;
        $data["group"] = $group;
        $data["info"] = $result;
        $data["request"] = request()->param();

        return view("admin/singlePage/edit", $data);
    }

    /**
     * @actionName  更新
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  单页列表
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();

        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/singlePage/index", $data);
    }

    /**
     * @actionName  批量设置级别
     * @show 2
     * 展示设置
     */
    public function updateLevel()
    {
        $result = $this->client->updateLevel();
        return jsonResponse($result);
    }
    /**
     * @actionName  批量设置排序
     * @show 2
     * 展示设置
     */
    public function updateSortWeightsBatch()
    {
        $result = $this->client->updateSortWeightsBatch();
        return jsonResponse($result);
    }
    /**
     * @actionName  生成静态页
     * @show 2
     * 展示设置
     */
    public function generateStaticPages($paramObj="")
    {
        $result = $this->client->generateStaticPages($paramObj);
        return jsonResponse($result);
    }
}