<?php

namespace app\admin\controller;

use app\client\admin\C_news;

class News
{
    public $c_news;

    /**
     * @menuName 新闻管理
     * 上面的是菜单的名字
     * @moduleName 新闻管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_news = new C_news();
    }

    /**
     * @actionName  新闻列表
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = $this->c_news->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/news/index", $data);
    }

    /**
     * @actionName  添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/news/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $response = $this->c_news->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $data = array();
            $data["rowData"] = $rowData;
            $data["request"] = request()->param();
            return view("admin/news/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * @actionName  创建资源
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->c_news->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  更新资源
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->c_news->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->c_news->delete();
        return jsonResponse($result);
    }
}