<?php

namespace app\admin\controller;

use ltcms\lib\Request;
use app\client\admin\C_module;

class Module
{
    public $c_module;

    /**
     * @menuName 系统设置
     * 上面的是菜单的名字
     * @moduleName 模块管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_module = new C_module();
    }

    /**
     * @actionName  模型列表
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = $this->c_module->listData($paramsObj);
        $moduleListData = array();
        if ($response["success"]) {
            $moduleListData = $response["data"];
        }
        $data = array();
        $data["moduleListData"] = $moduleListData;
        $data["request"] = request()->param();
        return view("admin/module/index", $data);
    }

    /**
     * @actionName  添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/module/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $response = $this->c_module->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $data = array();
            $data["rowData"] = $rowData;
            $data["request"] = request()->param();
            return view("admin/module/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * @actionName  创建资源
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->c_module->store();
        return jsonResponse($result);
    }

    /**
     * 补充路由数据
     */
    public function supplyRoute()
    {
        $result = $this->c_module->supplyRoute();
        return jsonResponse($result);
    }

    /**
     * @actionName  更新资源
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->c_module->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除资源
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->c_module->delete();
        return jsonResponse($result);
    }
}