<?php

namespace app\admin\controller;

use app\logic\admin\L_user;

class Index extends Init
{
    /**
     * @actionName 默认框架
     * @show 2
     * 展示设置
     */
    public function index()
    {
        $menuIdsInfoJson = $funcIdsInfoJson = "";
        $checkResult = (new L_user())->getUserMenu();
        if ($checkResult["error_no"] == 0) {
            $menuIdsInfoJson = json_encode($checkResult["result"]["menuIdsInfo"]);
            $funcIdsInfoJson = json_encode($checkResult["result"]["funcIdsInfo"]);
        }
        $data = array();
        $data["menuIdsInfoJson"] = $menuIdsInfoJson;
        $data["funcIdsInfoJson"] = $funcIdsInfoJson;
        $data["request"] = request()->param();
        return view("admin/layout/index", $data);
    }

    /**
     * @actionName 默认页面
     * @show 2
     * 展示设置
     */
    public function welcome()
    {
        $authData=array(
            "systemUpgrade_index"=>\Authorize_event::checkAuth('app\admin\controller\SystemUpgrade',"index"),
        );
        $siteTitle=siteSetting("siteTitle");
        $sysInfo = app("L_Admin_welcome")->sysInfo();

//        $response= app("C_Admin_system_upgrade")->cmsProject(); //获取程序版本
//        $cmsProject=array();
//        if ($response["success"]) {
//            $cmsProject = $response["data"];
//        }
        //获取授权信息
        $isAuthorized=$this->isAuthorized();
        $data = array();
        $data["authData"] = $authData;
        $data["siteTitle"] = $siteTitle;
        $data["sysInfo"] = $sysInfo;
        $data["isAuthorized"] = $isAuthorized;
        $data["version"] = app("L_Common_version")->info();
        $data["request"] = request()->param();
        return view("admin/default/welcome", $data);
    }

    /**
     * 获取授权key数据
     */
    public function isAuthorized(){
        $checkKey=new \Ltcms_domain_auth_check_key();
        $result=$checkKey->checkAuth();
        return $result;
    }
}