<?php

namespace app\admin\controller;

use app\client\admin\C_friendLink;
use app\logic\admin\L_friendLink;
use ltcms\lib\Request;
use ltcms\response\Response;

//友情链接管理
class FriendLink
{

    public $client;

    /**
     * @menuName 拓展管理
     * 上面的是菜单的名字
     * @moduleName 友链管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_friendLink();
    }


    /**
     * @actionName 资源详情
     * @show 2
     * 展示设置
     */
    public function info()
    {
        $result = $this->client->info();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $groupList = array();
        $checkResult = app("S_Admin_friendLinkGroup")->getAll(getParamsObj());
        if ($checkResult["error_no"] == 0) {
            $groupList = $checkResult["result"];
        }

        $data = array();
        $data["groupList"] = $groupList;
        $data["request"] = request()->param();
        return view("admin/friendLink/create", $data);

    }

    /**
     * @actionName 添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {

        $result = $this->client->store();
        return jsonResponse($result);

    }

    /**
     * @actionName 编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $groupList = array();
        $checkResult = app("S_Admin_friendLinkGroup")->getAll(getParamsObj());
        if ($checkResult["error_no"] == 0) {
            $groupList = $checkResult["result"];
        }


        $result = $this->client->info();
        if ($result["success"]) {
            $result = $result["data"];
        }
        $data = array();
        $data["info"] = $result;
        $data["groupList"] = $groupList;
        $data["request"] = request()->param();
        return view("admin/friendLink/edit", $data);

    }

    /**
     * @actionName 更新接口
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }


    /**
     * @actionName 删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  友情链接管理
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $groupList = array();
        $checkResult = app("S_Admin_friendLinkGroup")->getAll(getParamsObj());
        if ($checkResult["error_no"] == 0) {
            $groupList = $checkResult["result"];
        }


        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
            foreach ($rowData["data"] as $k => $v) {
                $groupName = "";
                if ($v["groupId"] == 0) {
                    $rowData["data"][$k]["groupName"] = "无分类";
                } else {
                    foreach ($groupList as $k2 => $v2) {
                        if ($v["groupId"] == $v2["id"]) {
                            $groupName = $v2["name"];
                            break;
                        }
                    }
                    $rowData["data"][$k]["groupName"] = $groupName;

                }
            }
        }
        $data = array();

        $data["rowData"] = $rowData;
        $data["request"] = request()->param();

        return view("admin/friendLink/index", $data);
    }
}