<?php

namespace app\admin\controller;

use app\client\admin\C_flow_data;

class Flow_data
{
    public $c_flow_data;



    /**
     * @menuName 流水数据
     * 上面的是菜单的名字
     * @moduleName 流水列表
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_flow_data = new C_flow_data();
    }

    /**
     * @actionName  流水列表
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = $this->c_flow_data->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/flow_data/index", $data);
    }

    /**
     * @actionName  添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/flow_data/create", $data);
    }

    /**
     * @actionName  编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $response = $this->c_flow_data->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $data = array();
            $data["rowData"] = $rowData;
            $data["request"] = request()->param();
            return view("admin/flow_data/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * @actionName  创建资源
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->c_flow_data->store();
        return jsonResponse($result);
    }

    /**
     * @actionName  更新资源
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->c_flow_data->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  删除资源
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->c_flow_data->delete();
        return jsonResponse($result);
    }
}