<?php

namespace app\admin\controller;

class Fields
{
    /**
     * 数据列表
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
        );
        $response = app("C_Admin_fields")->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/fields/index", $data);
    }

    /**
     * 添加
     */
    public function create()
    {
        $data = array();
        $data["request"] = request()->param();
        return view("admin/fields/create", $data);
    }

    /**
     * 使用说明
     */
    public function use_explain()
    {
        $id=request()->param("id");
        $name=request()->param("name");
        $use_explain=<<<EOF
表单名称：post_fields[{$name}]<br />
表单调用：{fields_show({$id})}<br />
内容调用：{\$article['{$name}']}<br />
EOF;
        $data = array();
        $data["use_explain"] = $use_explain;
        $data["request"] = request()->param();
        return view("admin/fields/use_explain", $data);
    }

    /**
     * 编辑
     */
    public function edit()
    {
        $response = app("C_Admin_fields")->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $data = array();
            $data["rowData"] = $rowData;
            $data["request"] = request()->param();
            return view("admin/fields/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * 创建资源
     */
    public function store()
    {
        $result = app("C_Admin_fields")->store();
        return jsonResponse($result);
    }

    /**
     * 更新资源
     */
    public function update()
    {
        $result = app("C_Admin_fields")->update();
        return jsonResponse($result);
    }

    /**
     * 删除
     */
    public function delete()
    {
        $result = app("C_Admin_fields")->delete();
        return jsonResponse($result);
    }
}