<?php

namespace app\admin\controller;

use app\client\admin\C_category;

class Category
{
    public $c_category;

    /**
     * @menuName {name}管理
     * 上面的是菜单的名字 {name} 为变量 表 module.name 值
     * @moduleName {name}分类管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_category = new C_category();
    }

    /**
     * @actionName 分类管理
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $dataType=request()->param("dataType");
        $dataId=request()->param("dataId");
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "format" => 1,
            "dataType" => $dataType,
            "dataId" => $dataId,
        );
        $response = $this->c_category->listData($paramsObj);
        $listData = array();
        if ($response["success"]) {
            $listData = $response["data"];
        }
        $data = array();
        $data["listData"] = $listData;
        $data["request"] = request()->param();
        return view("admin/category/index", $data);
    }

    /**
     * @actionName 添加
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $template=config("template.templateCategory",array());
        $data = array();
        $data["templateCategory"] = $template;
        $data["request"] = request()->param();
        return view("admin/category/create", $data);
    }

    /**
     * @actionName 编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $response = $this->c_category->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $template=config("template.templateCategory",array());
            $data = array();
            $data["templateCategory"] = $template;
            $data["rowData"] = $rowData;
            $data["request"] = request()->param();
            return view("admin/category/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * @actionName 取所有数据
     * @show 2
     * 展示设置
     */
    public function allData()
    {
        $result = $this->c_category->allData();
        return jsonResponse($result);
    }

    /**
     * @actionName 创建
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $result = $this->c_category->store();
        return jsonResponse($result);
    }

    /**
     * @actionName 更新资源
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $result = $this->c_category->update();
        return jsonResponse($result);
    }

    /**
     * @actionName 删除资源
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $result = $this->c_category->delete();
        return jsonResponse($result);
    }
}