<?php

namespace app\admin\controller;


use app\client\admin\C_adminRole;
use app\logic\admin\L_adminFunc;
use app\logic\admin\L_adminMenu;
use app\service\admin\S_adminFunc;


//控制层 渲染最后视图信息,模拟请求数据
class AdminRole
{
    public $client = null;

    /**
     * @menuName 后台权限
     * 上面的是菜单的名字
     * @moduleName 角色管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_adminRole();
    }

    /**
     * @actionName  添加角色
     * @show 2
     * 上面是否显示到菜单
     */
    public function create()
    {

        $data = array();
        $data["request"] = request()->param();
        return view("admin/adminRole/create", $data);

    }

    /**
     * @actionName  添加角色接口
     * @show 2
     * 上面是否显示到菜单
     */
    public function store()
    {

        $result = $this->client->store();
        return jsonResponse($result);

    }

    /**
     * @actionName  编辑角色
     * @show 2
     * 上面是否显示到菜单
     */
    public function edit()
    {

        $paramsObj = paramsObj();
        $paramsObj->params = array();

        $result = $this->client->info();
        if ($result["success"]) {
            $result = $result["data"];
        }

        $data = array();
        $data["info"] = $result;
        $data["request"] = request()->param();
        return view("admin/adminRole/edit", $data);

    }

    /**
     * @actionName  更新
     * @show 2
     * 上面是否显示到菜单
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }

    /**
     * @actionName  角色绑定功能
     * @show 2
     * 上面是否显示到菜单
     */
    public function roleFuncBind()
    {

        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $result = $this->client->info();
        if ($result["success"]) {
            $info = $result["data"];

            $paramsObj = paramsObj();
            $paramsObj->params = array();
            $result = (new L_adminFunc())->getAllJson();
            if ($result["error_no"] === 0) {
                $menuJson = json_encode($result["result"]);
            }
            $paramsObj = paramsObj();
            $paramsObj->params = array("roleId" => $info["id"]);
            $result = app("S_Admin_adminRoleFunc")->getRoleBindFunc($paramsObj);
            if ($result["error_no"] === 0) {
                if (is_array($result["result"]) && count($result["result"])>0){
                    $roleFuncList = join(',', $result["result"]) ;
                }else{
                    $roleFuncList="";
                }
            }
        }

        $data = array();
        $data["info"] = $info;   //角色基本信息
        $data["roleFuncList"] = $roleFuncList ?? array();     //角色已绑定功能
        $data["menuJson"] = $menuJson ?? array();     //所有菜单和功能列表

        $data["request"] = request()->param();
        return view("admin/adminRole/roleFuncBind", $data);
    }


    /**
     * @actionName  删除
     * @show 2
     * 上面是否显示到菜单
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  角色管理
     * @show 1
     * 上面是否显示到菜单
     */
    public function index()
    {

        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/adminRole/index", $data);
    }

    /**
     * @actionName  获取全部角色
     * @show 2
     * 上面是否显示到菜单
     */
    public function getAll()
    {
        $result = $this->client->getAll();
        return jsonResponse($result);
    }
}