<?php

namespace app\admin\controller;

use app\client\admin\C_adManage;



class AdManage
{
    public $client;

    /**
     * @menuName 拓展管理
     * 上面的是菜单的名字
     * @moduleName 广告管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->client = new C_adManage();
    }


    /**
     * @actionName 读取信息
     * @show 2
     * 上面是否显示到菜单
     */
    public function info()
    {
        $result = $this->client->info();
        return jsonResponse($result);
    }

    /**
     * @actionName 添加页
     * @show 2
     * 上面是否显示到菜单
     */
    public function create()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $adManageKeyVal = app("L_Admin_adPosition")->getAllkeyVal();
        $data = array();
        $data["adManageKeyVal"] = $adManageKeyVal; //全部广告信息
        $data["request"] = request()->param();
        return view("admin/adManage/create", $data);
    }

    /**
     * @actionName 添加接口
     * @show 2
     * 上面是否显示到菜单
     */
    public function store()
    {

        $result = $this->client->store();
        return jsonResponse($result);

    }

    /**
     * @actionName 编辑页
     * @show 2
     * 上面是否显示到菜单
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $adManageKeyVal = app("L_Admin_adPosition")->getAllkeyVal();

        $result = $this->client->info();
        if ($result["success"]) {
            //处理一下时间戳
            $result["data"]["startTime"] = $result["data"]["startTime"]?date('Y-m-d H:i:s', $result["data"]["startTime"]):"";
            $result["data"]["endTime"] = $result["data"]["endTime"]?date('Y-m-d H:i:s', $result["data"]["endTime"]):"";
            $result = $result["data"];
        }

        $data = array();
        $data["info"] = $result;
        $data["adManageKeyVal"] = $adManageKeyVal; //全部广告信息
        $data["request"] = request()->param();
        return view("admin/adManage/edit", $data);
    }

    /**
     * @actionName  编辑接口
     * @show 2
     * 上面是否显示到菜单
     */
    public function update()
    {
        $result = $this->client->update();
        return jsonResponse($result);
    }


    /**
     * @actionName  删除
     * @show 2
     * 上面是否显示到菜单
     */
    public function delete()
    {
        $result = $this->client->delete();
        return jsonResponse($result);
    }

    /**
     * @actionName  广告管理
     * @show 1
     * 上面是否显示到菜单
     */
    public function index()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $adManageKeyVal = app("L_Admin_adPosition")->getAllkeyVal();

        $paramsObj = paramsObj();
        $paramsObj->params = array();
        $response = $this->client->listData($paramsObj);
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        $data = array();
        $data["adManageKeyVal"] = $adManageKeyVal;
        $data["rowData"] = $rowData;
        $data["request"] = request()->param();
        return view("admin/adManage/index", $data);
    }
}